/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappings;
import com.amazon.ws.emr.hadoop.fs.rolemapping.S3CredentialsResolver;
import com.amazon.ws.emr.hadoop.fs.s3.lite.call.S3Call;
import com.amazon.ws.emr.hadoop.fs.util.AWSSessionCredentialsProviderFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.hadoop.conf.Configuration;

public final class RoleMappingS3CredentialsResolver
implements S3CredentialsResolver {
    private final FileSystemOwner fileSystemOwner;
    private final Configuration configuration;

    @Override
    public AWSCredentialsProvider resolve(S3Call call) {
        RoleMappingContext context = RoleMappingContext.builder().withFileSystemOwner(this.fileSystemOwner).withS3Resources(call.getS3Resources()).build();
        return AWSSessionCredentialsProviderFactory.getCredentialsProviderForRoleArn(RoleMappings.getRoleArnForContext(context), this.configuration);
    }

    public RoleMappingS3CredentialsResolver(FileSystemOwner fileSystemOwner, Configuration configuration) {
        this.fileSystemOwner = fileSystemOwner;
        this.configuration = configuration;
    }
}

