/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingType;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Region;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Regions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoleMapping {
    private static final Logger logger = LoggerFactory.getLogger(RoleMapping.class);
    @VisibleForTesting
    static final String ARN_SEPARATOR = "=";
    @VisibleForTesting
    static final String TARGET_SEPARATOR = ";";
    @VisibleForTesting
    static String VALID_IAM_ROLE_ARN_REGEX = null;
    protected static final String MATCH_SUCCESS_TEMPLATE = "Matching {} : {} with {}";
    protected final String roleArn;

    protected RoleMapping(String roleArn) {
        this.roleArn = roleArn;
    }

    @VisibleForTesting
    static RoleMapping fromConfig(String configuredMapping) {
        Preconditions.checkNotNull(configuredMapping);
        String mapping = configuredMapping.trim();
        String arn = mapping.substring(0, mapping.indexOf(ARN_SEPARATOR)).trim();
        mapping = mapping.substring(mapping.indexOf(ARN_SEPARATOR) + 1).trim();
        RoleMappingType roleMappingType = null;
        for (RoleMappingType type : RoleMappingType.values()) {
            String typeRegex = String.format("^%1$s\\s*%2$s(|[^%2$s].*)$", type.getEncoding(), ":");
            if (!mapping.toLowerCase().matches(typeRegex)) continue;
            roleMappingType = type;
            mapping = mapping.substring(mapping.indexOf(":") + 1).trim();
        }
        if (roleMappingType == null) {
            RoleMapping.failFromConfig(configuredMapping);
        }
        String[] targets = mapping.trim().split(TARGET_SEPARATOR);
        RoleMapping newMapping = roleMappingType.getBuilder().withRoleArn(arn).withTargets(targets).build();
        if (!newMapping.isValid()) {
            RoleMapping.failFromConfig(configuredMapping);
        }
        return newMapping;
    }

    private static void failFromConfig(String configuredMapping) {
        String errorMessage = String.format("%s is invalid. Expected format: <role arn>=<u|g|p>:<user|group|prefix>;<user|group|prefix>", configuredMapping);
        throw new IllegalArgumentException(errorMessage);
    }

    @VisibleForTesting
    static String sanitizeS3Path(String unsanitaryPath) {
        int indexOfFirstSlash;
        String S3_BUCKET_REGEX = "^[a-zA-Z0-9.\\-_]{1,255}$";
        String ERROR_MESSAGE = unsanitaryPath + " is not a valid prefix: %s";
        if (Strings.isNullOrEmpty(unsanitaryPath)) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, "Cannot be empty!"));
        }
        boolean shouldEndInSlash = false;
        String sanitizedPath = unsanitaryPath;
        if ((sanitizedPath = sanitizedPath.trim()).contains("://")) {
            int indexOfFirstCharacterAfterScheme = sanitizedPath.indexOf("://") + "://".length();
            sanitizedPath = sanitizedPath.substring(indexOfFirstCharacterAfterScheme).trim();
        }
        if ((indexOfFirstSlash = sanitizedPath.indexOf(47)) != -1 ? !sanitizedPath.substring(0, indexOfFirstSlash).matches("^[a-zA-Z0-9.\\-_]{1,255}$") : !sanitizedPath.matches("^[a-zA-Z0-9.\\-_]{1,255}$")) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, "Everything before first '/' must be legal bucket characters!"));
        }
        while (sanitizedPath.startsWith("/")) {
            sanitizedPath = sanitizedPath.substring(1).trim();
        }
        while (sanitizedPath.endsWith("/") || sanitizedPath.endsWith("*")) {
            if (!shouldEndInSlash && sanitizedPath.endsWith("/")) {
                shouldEndInSlash = true;
            }
            sanitizedPath = sanitizedPath.substring(0, sanitizedPath.length() - 1).trim();
        }
        if (sanitizedPath.isEmpty()) {
            throw new IllegalArgumentException(String.format(ERROR_MESSAGE, "Prefix must have legal characters!"));
        }
        if (shouldEndInSlash) {
            sanitizedPath = sanitizedPath + "/";
        }
        return sanitizedPath;
    }

    protected static boolean isRoleArnValid(String roleArn) {
        if (VALID_IAM_ROLE_ARN_REGEX == null) {
            VALID_IAM_ROLE_ARN_REGEX = RoleMapping.buildValidIAMRoleARNRegex();
        }
        return roleArn.matches(VALID_IAM_ROLE_ARN_REGEX);
    }

    private static String buildValidIAMRoleARNRegex() {
        String regexTemplate = "arn:%s:iam::[0-9]{12}:role/.*";
        Region currentRegion = Regions.getCurrentRegion();
        if (currentRegion == null) {
            throw new RuntimeException("EmrFS role mapping is not supported outside of EC2");
        }
        return String.format("arn:%s:iam::[0-9]{12}:role/.*", currentRegion.getPartition());
    }

    abstract boolean appliesTo(RoleMappingContext var1);

    protected String getRoleArn() {
        return this.roleArn;
    }

    abstract RoleMappingType getType();

    abstract String[] getTargets();

    protected boolean isValid() {
        return RoleMapping.isRoleArnValid(this.getRoleArn()) && this.hasTargets(this.getTargets());
    }

    protected boolean hasTargets(String[] targets) {
        return targets.length > 0 && Arrays.stream(targets).map(target -> !target.isEmpty()).reduce(true, Boolean::logicalAnd) != false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRoleArn());
        sb.append(ARN_SEPARATOR);
        sb.append(this.getType().getEncoding());
        sb.append(":");
        sb.append(Joiner.on(TARGET_SEPARATOR).join(this.getTargets()));
        return sb.toString();
    }

    public boolean equals(Object other) {
        String[] otherTargets;
        if (!(other instanceof RoleMapping)) {
            return false;
        }
        RoleMapping otherMapping = (RoleMapping)other;
        String[] myTargets = this.getTargets();
        if (myTargets.length == (otherTargets = otherMapping.getTargets()).length) {
            for (int i = 0; i < myTargets.length; ++i) {
                if (myTargets[i].equals(otherTargets[i])) continue;
                return false;
            }
        } else {
            return false;
        }
        return otherMapping.getClass().equals(this.getClass()) && otherMapping.getRoleArn().equals(this.getRoleArn());
    }
}

