/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.rolemapping;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMapping;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingBuilder;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingContext;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GroupRoleMapping
extends RoleMapping {
    private static final Logger logger = LoggerFactory.getLogger(GroupRoleMapping.class);
    private final String[] groupnames;

    GroupRoleMapping(String roleArn, String[] groupnames) {
        super(roleArn);
        this.groupnames = groupnames;
    }

    static GroupRoleMappingBuilder builder() {
        return new GroupRoleMappingBuilder();
    }

    @Override
    boolean appliesTo(RoleMappingContext context) {
        FileSystemOwner fileSystemOwner = context.getFileSystemOwner();
        if (fileSystemOwner == null) {
            return false;
        }
        for (String userGroup : fileSystemOwner.getGroupNames()) {
            for (String mappingGroup : this.getTargets()) {
                if (!userGroup.equals(mappingGroup)) continue;
                logger.debug("Matching {} : {} with {}", new Object[]{this, mappingGroup, fileSystemOwner});
                return true;
            }
        }
        return false;
    }

    @Override
    String[] getTargets() {
        return this.groupnames;
    }

    @Override
    RoleMappingType getType() {
        return RoleMappingType.GROUP;
    }

    static class GroupRoleMappingBuilder
    extends RoleMappingBuilder {
        @Override
        GroupRoleMapping build() {
            return new GroupRoleMapping(this.getRoleArn(), this.getTargets());
        }

        private GroupRoleMappingBuilder() {
        }
    }
}

