/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.retry;

import com.amazon.ws.emr.hadoop.fs.property.RetryPolicyType;
import com.amazon.ws.emr.hadoop.fs.retry.BackoffStrategy;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.MorePreconditions;
import java.net.SocketException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;

public final class BackoffStrategies {
    public static BackoffStrategy get(Configuration conf) {
        return BackoffStrategies.create(ConfigurationUtils.getRetryPolicyType(conf), ConfigurationUtils.getConsistencyRetryPeriodSeconds(conf) * 1000, ConfigurationUtils.getFastFirstRetryPeriodMs(conf));
    }

    public static BackoffStrategy exponential(long baseIntervalMs) {
        return BackoffStrategies.create(RetryPolicyType.EXPONENTIAL, baseIntervalMs, 0L);
    }

    @VisibleForTesting
    static BackoffStrategy create(RetryPolicyType policyType, long baseIntervalMs, long fastFirstRetryDelayMs) {
        BackoffStrategy baseStrategy;
        MorePreconditions.checkNotNegative(baseIntervalMs, "baseIntervalMs");
        MorePreconditions.checkNotNegative(fastFirstRetryDelayMs, "fastFirstRetryDelayMs");
        switch (policyType) {
            case EXPONENTIAL: {
                baseStrategy = BackoffStrategies.exponentialBase(baseIntervalMs);
                break;
            }
            case FAST_FIRST_RETRY_EXPONENTIAL: {
                baseStrategy = BackoffStrategies.fastFirstRetry(BackoffStrategies.exponentialBase(baseIntervalMs), fastFirstRetryDelayMs);
                break;
            }
            case FAST_FIRST_RETRY_FIXED: {
                baseStrategy = BackoffStrategies.fastFirstRetry(BackoffStrategies.fixedBase(baseIntervalMs), fastFirstRetryDelayMs);
                break;
            }
            default: {
                baseStrategy = BackoffStrategies.fixedBase(baseIntervalMs);
            }
        }
        return BackoffStrategies.withJitter(baseStrategy);
    }

    private static BackoffStrategy fastFirstRetry(BackoffStrategy fallback, long fastFirstRetryDelayMs) {
        return (e, retries) -> {
            long fallbackMs = fallback.getBackoffMillis(e, retries);
            return retries <= 0 && BackoffStrategies.isCauseBySocketError(e) ? Math.min(fastFirstRetryDelayMs, fallbackMs) : fallbackMs;
        };
    }

    private static BackoffStrategy exponentialBase(long baseIntervalMs) {
        return (e, retries) -> baseIntervalMs * (1L << retries);
    }

    private static BackoffStrategy fixedBase(long intervalMs) {
        return (e, retries) -> intervalMs;
    }

    private static BackoffStrategy withJitter(BackoffStrategy strategy) {
        return (e, retries) -> {
            double jitterMultiplier = ThreadLocalRandom.current().nextDouble() + 0.5;
            long backoffMillis = strategy.getBackoffMillis(e, retries);
            return (long)((double)backoffMillis * jitterMultiplier);
        };
    }

    private static boolean isCauseBySocketError(Exception e) {
        return e instanceof SocketException || ExceptionUtils.getRootCause(e) instanceof SocketException;
    }

    private BackoffStrategies() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

