/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.property;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public enum AwsS3SignerType {
    SIGV2("S3SignerType"),
    SIGV4("AWSS3V4SignerType");

    private final String name;

    @Nullable
    public static String fromName(String type) {
        return AwsS3SignerType.getNames().contains(type) ? type : null;
    }

    public static List<String> getNames() {
        return Stream.of(AwsS3SignerType.values()).map(AwsS3SignerType::getName).collect(Collectors.toList());
    }

    public static boolean isValidName(String name) {
        return AwsS3SignerType.fromName(name) != null;
    }

    public String getName() {
        return this.name;
    }

    private AwsS3SignerType(String name) {
        this.name = name;
    }
}

