/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.notification;

import com.amazon.ws.emr.hadoop.fs.notification.AbstractSQSMessage;
import com.amazon.ws.emr.hadoop.fs.notification.InconsistencySQSMessage;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.Gson;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQSNotifier
implements Notifier {
    private static final Logger logger = LoggerFactory.getLogger(SQSNotifier.class);
    private final AmazonSQS amazonSQS;
    private final Configuration configuration;
    private final Gson gson;
    private String url;

    public SQSNotifier(AmazonSQS amazonSQS, Configuration configuration, String queueName) {
        this.amazonSQS = amazonSQS;
        this.configuration = configuration;
        this.gson = new Gson();
        try {
            CreateQueueRequest createQueueRequest = new CreateQueueRequest(queueName);
            CreateQueueResult createQueueResult = amazonSQS.createQueue(createQueueRequest);
            this.url = createQueueResult.getQueueUrl();
            logger.info("Using SQS queue: " + this.url);
        }
        catch (Exception e) {
            logger.error("SQS queue " + queueName + " is unavailable, proceed with SQS notification disabled", (Throwable)e);
            this.url = "";
        }
    }

    public static String getDefaultQueueName(String jobFlowId) {
        return String.format("EMRFS-Inconsistency-%s", jobFlowId);
    }

    @Override
    public void inconsistency(Notifier.Api api, Path arg1, Path arg2, List<Path> inconsistentPaths) {
        if (!Strings.isNullOrEmpty(this.url)) {
            this.sendMessage(new InconsistencySQSMessage(this.configuration, api, arg1, arg2, inconsistentPaths));
        }
    }

    private void sendMessage(AbstractSQSMessage message) {
        try {
            String payload = this.gson.toJson(message);
            SendMessageRequest sendMessageRequest = new SendMessageRequest().withQueueUrl(this.url).withMessageBody(payload);
            this.amazonSQS.sendMessage(sendMessageRequest);
        }
        catch (Exception e) {
            logger.warn("Failed to send SQS notification: {}", (Object)message, (Object)e);
        }
    }
}

