/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.notification;

import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSQSMessage {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQSMessage.class);
    private static final int TRACE_DEPTH = 15;
    private Notifier.Api api;
    private String arg1;
    private String arg2;
    private long epoch;
    private String timestamp;
    private String username;
    private String hostname;
    private String jobId;
    private String taskId;
    private String attemptId;
    private String inputFile;
    private String logFile;
    private QueryType queryType;
    private String queryId;
    private List<String> stackTrace;
    private String customMsg;

    protected AbstractSQSMessage(Configuration configuration, Notifier.Api api, Path arg1, Path arg2) {
        this.api = api;
        if (arg1 != null) {
            this.arg1 = arg1.toString();
        }
        if (arg2 != null) {
            this.arg2 = arg2.toString();
        }
        this.hostname = "unknown";
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.warn("Failed to identify hostname", (Throwable)e);
        }
        this.epoch = System.currentTimeMillis();
        this.timestamp = new Date(this.epoch).toString();
        this.username = configuration.get("user.name", System.getProperty("user.name"));
        try {
            this.username = UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            logger.warn("Failed to identify user using hadoop library.", (Throwable)e);
        }
        this.customMsg = configuration.get("fs.s3.consistent.notification.SQS.customMsg");
        this.queryId = configuration.get("hive.query.id");
        this.queryType = QueryType.Unknown;
        if (this.queryId != null) {
            this.queryType = QueryType.Hive;
            this.logFile = configuration.get("hive.log.file");
        } else {
            this.queryId = configuration.get("pig.script.id");
            if (this.queryId != null) {
                this.queryType = QueryType.Pig;
                this.logFile = configuration.get("pig.logfile");
            }
        }
        this.taskId = configuration.get("mapreduce.task.id");
        if (Strings.isNullOrEmpty(this.taskId)) {
            this.taskId = configuration.get("mapred.tip.id");
        }
        this.attemptId = configuration.get("mapreduce.task.attempt.id");
        if (Strings.isNullOrEmpty(this.attemptId)) {
            this.attemptId = configuration.get("mapred.task.id");
        }
        this.inputFile = configuration.get("mapred.input.file");
        this.jobId = configuration.get("mapreduce.job.id");
        if (Strings.isNullOrEmpty(this.jobId)) {
            this.jobId = configuration.get("mapred.job.id");
        }
        try {
            if (this.jobId == null) {
                String[] split = configuration.get("mapreduce.job.dir").split("/");
                this.jobId = split[split.length - 1];
            }
        }
        catch (RuntimeException e) {
            logger.debug("Failed to determine job id");
        }
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            this.stackTrace = new ArrayList<String>(15);
            int depth = Math.min(15, stack.length);
            for (int i = 0; i < depth; ++i) {
                this.stackTrace.add(stack[i].toString());
            }
        }
        catch (Exception e) {
            logger.debug("Stacktrace generation failed", (Throwable)e);
        }
    }

    public Notifier.Api getApi() {
        return this.api;
    }

    public String getArg1() {
        return this.arg1;
    }

    public String getArg2() {
        return this.arg2;
    }

    public String getUsername() {
        return this.username;
    }

    public static enum QueryType {
        Hive,
        Pig,
        Unknown;

    }
}

