/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list.filter;

import com.amazon.ws.emr.hadoop.fs.list.filter.AbstractOrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.list.filter.OrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

final class StartAtOrderedListFilter
extends AbstractOrderedListFilter {
    @NonNull
    private final String startAt;

    @Override
    OrderedListFilter.Result filterNonEmptyPage(List<FileMetadata> page) {
        if (this.compareFirstKey(page, this.startAt) >= 0) {
            return OrderedListFilter.Result.shouldContinue(page);
        }
        if (this.compareLastKey(page, this.startAt) < 0) {
            return OrderedListFilter.Result.shouldContinue(Collections.emptyList());
        }
        int firstIndexToInclude = this.findSplitPoint(page, this.startAt, false);
        return OrderedListFilter.Result.shouldContinue(page.subList(firstIndexToInclude, page.size()));
    }

    public StartAtOrderedListFilter(@NonNull String startAt) {
        if (startAt == null) {
            throw new NullPointerException("startAt is marked non-null but is null");
        }
        this.startAt = startAt;
    }
}

