/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list.filter;

import com.amazon.ws.emr.hadoop.fs.list.filter.EndEarlyOrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.list.filter.StartAtOrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import java.util.List;
import lombok.NonNull;

public interface OrderedListFilter {
    public Result filter(List<FileMetadata> var1);

    public static OrderedListFilter startAt(String startAt) {
        return new StartAtOrderedListFilter(startAt);
    }

    public static OrderedListFilter endBefore(String endBefore) {
        return new EndEarlyOrderedListFilter(endBefore, false);
    }

    public static OrderedListFilter endAt(String endAt) {
        return new EndEarlyOrderedListFilter(endAt, true);
    }

    public static OrderedListFilter composite(@NonNull List<OrderedListFilter> filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return page -> {
            boolean shouldContinue = true;
            List<FileMetadata> current = page;
            for (OrderedListFilter filter : filters) {
                Result result = filter.filter(current);
                shouldContinue &= result.shouldContinue;
                current = result.getPage();
            }
            return new Result(current, shouldContinue);
        };
    }

    public static final class Result {
        private final List<FileMetadata> page;
        private final boolean shouldContinue;

        static Result shouldContinue(List<FileMetadata> page) {
            return new Result(page, true);
        }

        static Result shouldAbort(List<FileMetadata> page) {
            return new Result(page, false);
        }

        public Result(List<FileMetadata> page, boolean shouldContinue) {
            this.page = page;
            this.shouldContinue = shouldContinue;
        }

        public List<FileMetadata> getPage() {
            return this.page;
        }

        public boolean isShouldContinue() {
            return this.shouldContinue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            List<FileMetadata> this$page = this.getPage();
            List<FileMetadata> other$page = other.getPage();
            if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
                return false;
            }
            return this.isShouldContinue() == other.isShouldContinue();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<FileMetadata> $page = this.getPage();
            result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
            result = result * 59 + (this.isShouldContinue() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "OrderedListFilter.Result(page=" + this.getPage() + ", shouldContinue=" + this.isShouldContinue() + ")";
        }
    }
}

