/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list.filter;

import com.amazon.ws.emr.hadoop.fs.list.filter.AbstractOrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.list.filter.OrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

final class EndEarlyOrderedListFilter
extends AbstractOrderedListFilter {
    @NonNull
    private final String end;
    private final boolean inclusive;

    @Override
    OrderedListFilter.Result filterNonEmptyPage(List<FileMetadata> page) {
        if (this.compareLastKey(page, this.end) < 0) {
            return OrderedListFilter.Result.shouldContinue(page);
        }
        if (this.compareFirstKey(page, this.end) > 0) {
            return OrderedListFilter.Result.shouldAbort(Collections.emptyList());
        }
        int firstIndexToExclude = this.findSplitPoint(page, this.end, this.inclusive);
        return OrderedListFilter.Result.shouldAbort(page.subList(0, firstIndexToExclude));
    }

    public EndEarlyOrderedListFilter(@NonNull String end, boolean inclusive) {
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.end = end;
        this.inclusive = inclusive;
    }
}

