/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list.filter;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class DescendantOfFileKeyFilter
implements Predicate<String> {
    private KeyPrefixes seenKeys = new KeyPrefixes();

    @Override
    public boolean test(String inputKey) {
        if (inputKey.isEmpty()) {
            return false;
        }
        int commonOffset = 0;
        for (int i = 0; i < this.seenKeys.size(); ++i) {
            KeyPrefixes.Key seenKey = this.seenKeys.get(i);
            Comparison comparison = seenKey.compareTo(inputKey, commonOffset);
            Preconditions.checkArgument(comparison.isLessThanOrEqual(), "Input key '%s' cannot be tested after '%s'", inputKey, this.seenKeys.last());
            if (comparison.isEqual()) {
                Preconditions.checkArgument(i + 1 == this.seenKeys.size(), "Input key '%s' cannot be tested after '%s'", inputKey, this.seenKeys.last());
                return true;
            }
            if (!comparison.isPrefix()) {
                this.seenKeys.replaceRemaining(i, inputKey);
                return true;
            }
            int delimiterCompare = Character.compare('/', inputKey.charAt(seenKey.length()));
            if (delimiterCompare < 0) {
                this.seenKeys.replaceRemaining(i, inputKey);
                return true;
            }
            if (delimiterCompare == 0) {
                return false;
            }
            commonOffset = seenKey.length();
        }
        this.seenKeys.add(inputKey);
        return true;
    }

    private static class Comparison {
        final int value;
        final boolean isPrefix;

        boolean isEqual() {
            return this.value == 0;
        }

        boolean isLessThanOrEqual() {
            return this.value <= 0;
        }

        public Comparison(int value, boolean isPrefix) {
            this.value = value;
            this.isPrefix = isPrefix;
        }

        public boolean isPrefix() {
            return this.isPrefix;
        }
    }

    static class KeyPrefixes {
        private final List<Key> keys = new ArrayList<Key>();
        private String lastKey;

        KeyPrefixes() {
        }

        int size() {
            return this.keys.size();
        }

        Key get(int index) {
            return this.keys.get(index);
        }

        Key last() {
            return this.keys.get(this.keys.size() - 1);
        }

        void replaceRemaining(int index, String newLastKey) {
            this.keys.subList(index, this.keys.size()).clear();
            this.add(newLastKey);
        }

        void add(String newLastKey) {
            this.lastKey = newLastKey;
            this.keys.add(new Key(newLastKey.length()));
        }

        class Key {
            private final int length;

            int length() {
                return this.length;
            }

            int codePointAt(int index) {
                Preconditions.checkElementIndex(index, this.length);
                return KeyPrefixes.this.lastKey.codePointAt(index);
            }

            Comparison compareTo(String otherKey, int commonOffset) {
                int codePoint;
                for (int i = commonOffset; i < this.length() && i < otherKey.length(); i += Character.charCount(codePoint)) {
                    int otherCodePoint;
                    codePoint = this.codePointAt(i);
                    int result = Integer.compare(codePoint, otherCodePoint = otherKey.codePointAt(i));
                    if (result == 0) continue;
                    return new Comparison(result, false);
                }
                int result = Integer.compare(this.length(), otherKey.length());
                return new Comparison(result, true);
            }

            public String toString() {
                return KeyPrefixes.this.lastKey.substring(0, this.length);
            }

            public Key(int length) {
                this.length = length;
            }
        }
    }
}

