/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list.filter;

import com.amazon.ws.emr.hadoop.fs.list.S3KeyOrdering;
import com.amazon.ws.emr.hadoop.fs.list.filter.OrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

abstract class AbstractOrderedListFilter
implements OrderedListFilter {
    AbstractOrderedListFilter() {
    }

    @Override
    public OrderedListFilter.Result filter(List<FileMetadata> page) {
        if (page.isEmpty()) {
            return OrderedListFilter.Result.shouldContinue(page);
        }
        return this.filterNonEmptyPage(page);
    }

    abstract OrderedListFilter.Result filterNonEmptyPage(List<FileMetadata> var1);

    int compareFirstKey(List<FileMetadata> page, String key) {
        FileMetadata first = page.get(0);
        return S3KeyOrdering.compare(first.getKey(), key);
    }

    int compareLastKey(List<FileMetadata> page, String key) {
        FileMetadata last = Iterables.getLast(page);
        return S3KeyOrdering.compare(last.getKey(), key);
    }

    int findSplitPoint(List<FileMetadata> page, String key, boolean afterKey) {
        List pageKeys = Lists.transform(page, FileMetadata::getKey);
        int index = Collections.binarySearch(pageKeys, key, S3KeyOrdering.comparator());
        if (index >= 0) {
            return afterKey ? index + 1 : index;
        }
        return -1 * (index + 1);
    }
}

