/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list;

import com.amazon.ws.emr.hadoop.fs.list.CodePointComparator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.util.Comparator;
import lombok.NonNull;

public final class S3KeyOrdering {
    private static final Comparator<String> KEY_COMPARATOR = CodePointComparator.getInstance();

    public static Comparator<String> comparator() {
        return KEY_COMPARATOR;
    }

    public static int compare(String left, String right) {
        return KEY_COMPARATOR.compare(left, right);
    }

    public static String approximateKeyJustBefore(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Preconditions.checkArgument(!key.isEmpty(), "key must not be empty");
        int finalCodePoint = key.codePointBefore(key.length());
        int prefixLength = key.length() - Character.charCount(finalCodePoint);
        String prefix = key.substring(0, prefixLength);
        if (finalCodePoint <= 1) {
            return prefix;
        }
        int previousFinalCodePoint = finalCodePoint - 1;
        int adjustedPreviousFinalCodePoint = S3KeyOrdering.isSurrogate(previousFinalCodePoint) ? 55295 : previousFinalCodePoint;
        int[] suffixCodePoints = new int[]{adjustedPreviousFinalCodePoint, 0x10FFFF};
        String suffix = new String(suffixCodePoints, 0, suffixCodePoints.length);
        return prefix + suffix;
    }

    public static String getKeyJustAfterPrefix(@NonNull String prefix) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        Preconditions.checkArgument(!prefix.isEmpty(), "prefix must not be empty");
        Preconditions.checkArgument(prefix.endsWith("/"), "prefix must end with '/'");
        String trailingSeparatorStripped = prefix.substring(0, prefix.length() - 1);
        char nextChar = '0';
        return trailingSeparatorStripped + nextChar;
    }

    private static boolean isSurrogate(int codePoint) {
        return codePoint >= 55296 && codePoint <= 57343;
    }

    private S3KeyOrdering() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

