/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list;

import com.amazon.ws.emr.hadoop.fs.list.S3KeyOrdering;
import com.amazon.ws.emr.hadoop.fs.list.filter.DescendantOfFileKeyFilter;
import com.amazon.ws.emr.hadoop.fs.list.filter.OrderedListFilter;
import com.amazon.ws.emr.hadoop.fs.s3n.FileMetadata;
import com.amazon.ws.emr.hadoop.fs.s3n.NativeFileSystemStore;
import com.amazon.ws.emr.hadoop.fs.s3n.PartialListing;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.list.OrderedListing;
import org.apache.hadoop.fs.list.OrderedListingBuilder;

public class OnlyFilesOrderedListing
extends OrderedListing {
    private final NativeFileSystemStore store;
    private final Function<FileMetadata, LocatedFileStatus> fileStatusFactory;
    @NonNull
    private final String key;
    private final String startAfter;
    private final boolean recursive;
    @NonNull
    private final OrderedListFilter filter;
    private final boolean includeDescendantsOfFiles;
    private boolean started;
    private String continuationToken;
    private final Predicate<String> descendantOfFileKeyFilter = new DescendantOfFileKeyFilter();

    public boolean hasNext() {
        return !this.started || this.continuationToken != null;
    }

    public List<LocatedFileStatus> next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("All pages have already been listed");
        }
        try {
            return this.getNextPage();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private List<LocatedFileStatus> getNextPage() throws IOException {
        this.started = true;
        PartialListing listing = this.store.list(this.key, 1000, this.startAfter, this.continuationToken, this.recursive);
        List<FileMetadata> listedFiles = listing.getFiles();
        OrderedListFilter.Result result = this.filter.filter(listedFiles);
        this.continuationToken = result.isShouldContinue() ? listing.getNextContinuationToken() : null;
        return result.getPage().stream().filter(file -> !OnlyFilesOrderedListing.isFolderMarker(file)).filter(this::isDiscoverableFile).map(this.fileStatusFactory).collect(Collectors.toList());
    }

    private static boolean isFolderMarker(FileMetadata file) {
        return file.getKey().endsWith("_$folder$") || file.getKey().endsWith("/");
    }

    private boolean isDiscoverableFile(FileMetadata file) {
        return !this.recursive || this.includeDescendantsOfFiles || this.descendantOfFileKeyFilter.test(file.getKey());
    }

    OnlyFilesOrderedListing(NativeFileSystemStore store, Function<FileMetadata, LocatedFileStatus> fileStatusFactory, @NonNull String key, String startAfter, boolean recursive, @NonNull OrderedListFilter filter, boolean includeDescendantsOfFiles) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        this.store = store;
        this.fileStatusFactory = fileStatusFactory;
        this.key = key;
        this.startAfter = startAfter;
        this.recursive = recursive;
        this.filter = filter;
        this.includeDescendantsOfFiles = includeDescendantsOfFiles;
    }

    public static class Builder
    implements OrderedListingBuilder {
        private final NativeFileSystemStore store;
        private final Consumer<Path> pathChecker;
        private final Function<FileMetadata, LocatedFileStatus> fileStatusFactory;
        private final Configuration conf;
        private final String key;
        private boolean recursive;
        private String startAt;
        private String endAt;

        public OrderedListingBuilder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public OrderedListingBuilder startAt(@Nullable Path path) {
            this.startAt = this.getKey(path);
            return this;
        }

        public OrderedListingBuilder endAt(@Nullable Path path) {
            this.endAt = this.getKey(path);
            return this;
        }

        public OrderedListing build() {
            String startAfter = null;
            ArrayList<OrderedListFilter> filters = new ArrayList<OrderedListFilter>();
            if (StringUtils.isNotEmpty(this.startAt)) {
                startAfter = S3KeyOrdering.approximateKeyJustBefore(this.startAt);
                filters.add(OrderedListFilter.startAt(this.startAt));
            }
            if (StringUtils.isNotEmpty(this.endAt)) {
                if (this.recursive) {
                    String endBefore = S3KeyOrdering.getKeyJustAfterPrefix(this.endAt + "/");
                    filters.add(OrderedListFilter.endBefore(endBefore));
                } else {
                    filters.add(OrderedListFilter.endAt(this.endAt));
                }
            }
            OrderedListFilter compositeFilter = OrderedListFilter.composite(filters);
            return new OnlyFilesOrderedListing(this.store, this.fileStatusFactory, this.key, startAfter, this.recursive, compositeFilter, this.includeDescendantsOfFiles());
        }

        private String getKey(@Nullable Path path) {
            if (path == null) {
                return null;
            }
            Preconditions.checkArgument(HadoopPaths.isAbsoluteWhenNormalized(path), "Path must be absolute: %s", path);
            this.pathChecker.accept(path);
            return S3UriUtils.pathToKey(path);
        }

        private boolean includeDescendantsOfFiles() {
            return ConfigurationUtils.includeDescendantsOfFilesForListFilesInOrder(this.conf);
        }

        public Builder(NativeFileSystemStore store, Consumer<Path> pathChecker, Function<FileMetadata, LocatedFileStatus> fileStatusFactory, Configuration conf, String key) {
            this.store = store;
            this.pathChecker = pathChecker;
            this.fileStatusFactory = fileStatusFactory;
            this.conf = conf;
            this.key = key;
        }
    }
}

