/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.list;

import com.amazon.ws.emr.hadoop.fs.list.S3KeyOrdering;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import java.util.Comparator;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

public final class ListOrderComparator
implements Comparator<Path> {
    @NonNull
    private final Consumer<Path> pathChecker;

    @Override
    public int compare(Path left, Path right) {
        this.checkPath(left);
        this.checkPath(right);
        String leftPath = this.normalize(left.toUri().getPath());
        String rightPath = this.normalize(right.toUri().getPath());
        return S3KeyOrdering.compare(leftPath, rightPath);
    }

    private void checkPath(Path path) {
        Preconditions.checkArgument(HadoopPaths.isAbsoluteWhenNormalized(path), "Path must be absolute: %s", path);
        this.pathChecker.accept(path);
    }

    private String normalize(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        if (!path.equals("/") && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public ListOrderComparator(@NonNull Consumer<Path> pathChecker) {
        if (pathChecker == null) {
            throw new NullPointerException("pathChecker is marked non-null but is null");
        }
        this.pathChecker = pathChecker;
    }
}

