/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.identity;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemOwner
implements FileSystemOwner {
    private static final Logger logger = LoggerFactory.getLogger(HadoopFileSystemOwner.class);
    private final UserGroupInformation underlyingUserGroupInformation;
    private final boolean ugiGetGroupEnabled;

    public HadoopFileSystemOwner(UserGroupInformation ugi) {
        this(ugi, new Configuration());
    }

    public HadoopFileSystemOwner(UserGroupInformation ugi, Configuration conf) {
        Preconditions.checkNotNull(ugi);
        this.underlyingUserGroupInformation = ugi;
        Preconditions.checkNotNull(conf);
        this.ugiGetGroupEnabled = ConfigurationUtils.isUgiGetGroupEnabled(conf);
    }

    @Override
    public String getFullUserName() {
        return this.underlyingUserGroupInformation.getUserName();
    }

    @Override
    public String getShortUserName() {
        return this.underlyingUserGroupInformation.getShortUserName();
    }

    @Override
    public String getGroup() {
        if (!this.ugiGetGroupEnabled) {
            return this.underlyingUserGroupInformation.getShortUserName();
        }
        try {
            return this.underlyingUserGroupInformation.getPrimaryGroupName();
        }
        catch (IOException ioe) {
            logger.warn("found no group information for {}, using {} as primary group", (Object)this.underlyingUserGroupInformation, (Object)this.getFullUserName());
            return this.getFullUserName();
        }
    }

    @Override
    public String[] getGroupNames() {
        if (!this.ugiGetGroupEnabled) {
            return new String[]{this.underlyingUserGroupInformation.getShortUserName()};
        }
        return this.underlyingUserGroupInformation.getGroupNames();
    }

    public String toString() {
        return this.underlyingUserGroupInformation.toString();
    }
}

