/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice.providers;

import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwnerInitializationException;
import com.amazon.ws.emr.hadoop.fs.identity.HadoopFileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import java.io.IOException;
import javax.inject.Provider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class FileSystemOwnerProvider
implements Provider<FileSystemOwner> {
    private Configuration configuration;

    @Inject
    public FileSystemOwnerProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    public FileSystemOwner get() {
        try {
            return new HadoopFileSystemOwner(UserGroupInformation.getCurrentUser(), this.configuration);
        }
        catch (IOException ioe) {
            throw new FileSystemOwnerInitializationException(ioe);
        }
    }
}

