/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice.providers;

import com.amazon.ws.emr.hadoop.fs.guice.BlockFastProducerPolicy;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Provider;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;

public class ExecutorServiceProvider
implements Provider<ExecutorService> {
    private final Configuration configuration;

    @Inject
    public ExecutorServiceProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ExecutorService get() {
        ThreadFactory daemonThreadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("s3n-worker-%d").build();
        int threadPoolSize = ConfigurationUtils.getS3ThreadPoolSize(this.configuration);
        int threadPoolBufferSize = ConfigurationUtils.getThreadPoolBufferSize(this.configuration);
        if (threadPoolBufferSize < threadPoolSize) {
            threadPoolBufferSize = 10000;
        }
        return new ThreadPoolExecutor(threadPoolSize, 40, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(threadPoolBufferSize), daemonThreadFactory, new BlockFastProducerPolicy());
    }
}

