/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.identity.HadoopFileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappings;
import com.amazon.ws.emr.hadoop.fs.util.AWSSessionCredentialsProviderFactory;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupMappingAWSSessionCredentialsProvider
implements AWSSessionCredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(UserGroupMappingAWSSessionCredentialsProvider.class);
    private final Optional<UserGroupInformation> ownerOptional;
    private final Configuration configuration;

    public UserGroupMappingAWSSessionCredentialsProvider() {
        this(new Configuration());
    }

    public UserGroupMappingAWSSessionCredentialsProvider(Configuration configuration) {
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ownerOptional = Optional.ofNullable(currentUser);
        this.configuration = configuration;
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        if (!this.ownerOptional.isPresent()) {
            return null;
        }
        UserGroupInformation ugi = this.ownerOptional.get();
        logger.debug("retrieving credentials for {}, short name {}", (Object)ugi, (Object)ugi.getShortUserName());
        if (UserGroupInformation.isSecurityEnabled() && ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.SIMPLE) {
            return null;
        }
        AWSSessionCredentialsProvider sessionCredentialsProvider = AWSSessionCredentialsProviderFactory.getCredentialsProviderForRoleArn(RoleMappings.getRoleArnForFileSystemOwner(new HadoopFileSystemOwner(ugi, this.configuration)), this.configuration);
        if (sessionCredentialsProvider != null) {
            return sessionCredentialsProvider.getCredentials();
        }
        return null;
    }

    @Override
    public void refresh() {
    }
}

