/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.guice.CredentialsProviderOverrider;
import com.amazon.ws.emr.hadoop.fs.guice.RequesterPaysOverrider;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.rolemapping.RoleMappingS3CredentialsResolver;
import com.amazon.ws.emr.hadoop.fs.s3.lite.executor.S3CallOverrider;
import com.amazon.ws.emr.hadoop.fs.secretagent.SecretAgentS3CredentialsResolver;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.SecretAgentClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.emr.secretagent.client.SecretAgentClientFactory;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public final class S3CallOverridesGetter {
    public static List<S3CallOverrider> getS3CallOverriders(Configuration configuration, FileSystemOwner fileSystemOwner) {
        ImmutableList.Builder<S3CallOverrider> builder = ImmutableList.builder();
        if (ConfigurationUtils.isUseRequesterPaysHeader(configuration).booleanValue()) {
            builder.add((Object)new RequesterPaysOverrider());
        }
        return S3CallOverridesGetter.addCredentialsProvider(configuration, fileSystemOwner, builder);
    }

    private static List<S3CallOverrider> addCredentialsProvider(Configuration configuration, FileSystemOwner fileSystemOwner, ImmutableList.Builder<S3CallOverrider> builder) {
        if (fileSystemOwner == null) {
            return builder.build();
        }
        if (ConfigurationUtils.isSecretAgentAuthEnabled(configuration)) {
            SecretAgentClient secretAgentClient = SecretAgentClientFactory.getDefaultClient();
            builder.add((Object)new CredentialsProviderOverrider(new SecretAgentS3CredentialsResolver(secretAgentClient, fileSystemOwner)));
        } else {
            builder.add((Object)new CredentialsProviderOverrider(new RoleMappingS3CredentialsResolver(fileSystemOwner, configuration)));
        }
        return builder.build();
    }
}

