/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.guice.providers.ExecutorServiceProvider;
import com.amazon.ws.emr.hadoop.fs.guice.providers.FileSystemOwnerProvider;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.maintenance.MultipartUploadCleaner;
import com.amazon.ws.emr.hadoop.fs.notification.NotificationDispatcher;
import com.amazon.ws.emr.hadoop.fs.notification.Notifier;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3n.S3NativeFileSystem;
import com.amazon.ws.emr.hadoop.fs.s3n2.S3NativeFileSystem2;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.AbstractModule;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Provides;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Singleton;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.TypeLiteral;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.name.Names;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmrFSBaseModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(EmrFSBaseModule.class);
    public static final String S3N = "s3n";
    public static final String S3N2 = "s3n2";
    protected final URI uri;
    protected final Configuration configuration;
    protected FileSystem.Statistics statistics;

    protected abstract AWSCredentialsProvider getAwsCredentialsProvider(String var1);

    protected abstract AWSCredentialsProvider getAwsCredentialsProvider();

    protected abstract AmazonS3Lite createAmazonS3Lite(FileSystemOwner var1);

    protected abstract AmazonDynamoDB createAmazonDynamoDB();

    protected abstract EntityStore<Entity> createEntityStore(AmazonDynamoDB var1);

    protected abstract List<Notifier> getNotifiers();

    @Override
    protected void configure() {
        this.bind(EntityStore.class).to((TypeLiteral<EntityStore>)new TypeLiteral<EntityStore<Entity>>(){});
        this.bind(FileSystem.class).annotatedWith(Names.named(S3N)).to(S3NativeFileSystem.class);
        this.bind(FileSystem.class).annotatedWith(Names.named(S3N2)).to(S3NativeFileSystem2.class);
        this.bind(FileSystemOwner.class).toProvider(FileSystemOwnerProvider.class).asEagerSingleton();
        this.bind(ExecutorService.class).toProvider(ExecutorServiceProvider.class);
    }

    @Singleton
    @Provides
    protected MultipartUploadCleaner createMultipartUploadCleaner(AmazonS3Lite s3) {
        return MultipartUploadCleaner.getInstance(this.configuration, s3);
    }

    @Singleton
    @Provides
    AWSCredentialsProvider provideAWSCredentialsProvider() {
        return this.getAwsCredentialsProvider();
    }

    @Singleton
    @Provides
    EntityStore<Entity> provideEntityStore(@Nullable AmazonDynamoDB dynamoDB) {
        return this.createEntityStore(dynamoDB);
    }

    @Singleton
    @Provides
    AmazonS3Lite provideAmazonS3Lite(FileSystemOwner fileSystemOwner) {
        return this.createAmazonS3Lite(fileSystemOwner);
    }

    @Singleton
    @Provides
    AmazonDynamoDB provideAmazonDynamoDB() {
        return this.createAmazonDynamoDB();
    }

    @Provides
    Configuration provideConfiguration() {
        return this.configuration;
    }

    @Provides
    URI provideBaseUri() {
        return this.uri;
    }

    @Provides
    FileSystem.Statistics provideStatistics() {
        return this.statistics;
    }

    @Provides
    @Singleton
    NotificationDispatcher provideNotificationDispatcher() {
        NotificationDispatcher notificationDispatcher = new NotificationDispatcher();
        notificationDispatcher.addNotifiers(this.getNotifiers());
        return notificationDispatcher;
    }

    @Provides
    ListeningExecutorService provideListeningExecutorService(ExecutorService executorService) {
        return MoreExecutors.listeningDecorator(executorService);
    }

    public EmrFSBaseModule(URI uri, Configuration configuration, FileSystem.Statistics statistics) {
        this.uri = uri;
        this.configuration = configuration;
        this.statistics = statistics;
    }
}

