/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.NativeDynamoDBEntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreExceptionCode;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.RetriableEntityStoreException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonWebServiceRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.gson.Gson;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.tuple.Pair;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBRetryCondition
extends PredefinedRetryPolicies.SDKDefaultRetryCondition {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDBRetryCondition.class);
    private final int updateThroughputTimeoutSeconds = 300;
    private final int maxErrorRetry;
    private final boolean autoIncrease;
    private final String entitystoreTagUpdateLock = "UpdateLock";
    private NativeDynamoDBEntityStore nativeDynamoDBEntityStore;
    private AtomicBoolean updating;
    private long maxRead;
    private long maxWrite;
    private double factor;
    private String owner;
    private AtomicLong throttled;

    public DynamoDBRetryCondition(AmazonDynamoDB dynamoDB, String tableName, int maxErrorRetry, boolean autoIncrease, boolean etagVerification, long maxRead, long maxWrite, double factor) {
        this.autoIncrease = autoIncrease;
        this.maxErrorRetry = maxErrorRetry;
        this.throttled = new AtomicLong(0L);
        if (autoIncrease) {
            this.updating = new AtomicBoolean(false);
            this.nativeDynamoDBEntityStore = new NativeDynamoDBEntityStore(dynamoDB).withAutoCreateTable(false).withTableName(tableName).withConditionalUpdate(true).withPrefetching(false).withEtagVerification(etagVerification);
            this.nativeDynamoDBEntityStore.initialize();
            this.maxRead = maxRead;
            this.maxWrite = maxWrite;
            this.factor = 1.0 + factor;
            try {
                this.owner = Inet4Address.getLocalHost().getHostName() + "-";
            }
            catch (UnknownHostException e) {
                this.owner = "";
            }
            this.owner = this.owner + UUID.randomUUID().toString();
        } else {
            logger.debug("Throughput auto-increase is disabled.");
        }
    }

    private void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private DynamoDBOpType getDynamoDBOpType(AmazonWebServiceRequest request) {
        if (request instanceof BatchGetItemRequest || request instanceof GetItemRequest || request instanceof QueryRequest || request instanceof ScanRequest) {
            return DynamoDBOpType.READ;
        }
        if (request instanceof BatchWriteItemRequest || request instanceof DeleteItemRequest || request instanceof PutItemRequest || request instanceof UpdateItemRequest) {
            return DynamoDBOpType.WRITE;
        }
        return DynamoDBOpType.OTHER;
    }

    public boolean lockBeforeIncrease() {
        long timeout = DateTime.now().plusSeconds(300).getMillis();
        UpdateLock newUpdateLock = new UpdateLock(this.owner, false, timeout);
        ItemKey itemKey = new ItemKey("MultiKeyStoreTag", "UpdateLock");
        try {
            Entity entity = this.nativeDynamoDBEntityStore.retrieve(itemKey);
            if (entity == null) {
                this.nativeDynamoDBEntityStore.create(new Entity(itemKey, newUpdateLock.toByteArray()));
                return true;
            }
            UpdateLock currentUpdateLock = UpdateLock.fromByteArray(entity.getPayload());
            if (currentUpdateLock.completed || DateTime.now().getMillis() > currentUpdateLock.timeout || currentUpdateLock.owner.equals(this.owner)) {
                this.nativeDynamoDBEntityStore.update(entity.withPayload(newUpdateLock.toByteArray()));
                return true;
            }
            return false;
        }
        catch (EntityStoreException e) {
            if (e.getEntityStoreExceptionCode() == EntityStoreExceptionCode.ALREADY_EXISTS || e.getEntityStoreExceptionCode() == EntityStoreExceptionCode.STALE_ENTITY) {
                logger.debug("Throughput is being updated by another thread.");
                return false;
            }
            throw e;
        }
        catch (RetriableEntityStoreException e) {
            return false;
        }
    }

    public boolean unlockAfterIncrease() {
        ItemKey itemKey = new ItemKey("MultiKeyStoreTag", "UpdateLock");
        try {
            Entity entity = this.nativeDynamoDBEntityStore.retrieve(itemKey);
            if (entity == null) {
                logger.warn("Lock item has been deleted from DynamoDB unexpectedly");
            } else {
                UpdateLock currentUpdateLock = UpdateLock.fromByteArray(entity.getPayload());
                if (currentUpdateLock.owner.equals(this.owner)) {
                    this.nativeDynamoDBEntityStore.delete(entity);
                } else {
                    logger.warn("Throughput is being updated by another thread {}, possibly due to timeout.", (Object)currentUpdateLock.owner);
                }
            }
            return true;
        }
        catch (EntityStoreException e) {
            if (e.getEntityStoreExceptionCode() == EntityStoreExceptionCode.STALE_ENTITY) {
                logger.warn("Throughput is being updated by another thread.");
                return true;
            }
            throw e;
        }
        catch (RetriableEntityStoreException e) {
            return false;
        }
    }

    private void autoIncrease(DynamoDBOpType opType) {
        if (!this.updating.getAndSet(true)) {
            long targetWrite;
            long targetRead;
            Pair<Long, Long> throughputSettings = this.nativeDynamoDBEntityStore.getProvisionedThroughput();
            if (throughputSettings != null) {
                if (opType == DynamoDBOpType.READ) {
                    targetRead = Math.min((long)((double)throughputSettings.getLeft().longValue() * this.factor), this.maxRead);
                    targetWrite = throughputSettings.getRight();
                } else {
                    targetRead = throughputSettings.getLeft();
                    targetWrite = Math.min((long)((double)throughputSettings.getRight().longValue() * this.factor), this.maxWrite);
                }
            } else {
                logger.debug("Provisioned throughput is being increased by another thread, try later.");
                this.updating.set(false);
                return;
            }
            logger.info("Trying to increase provisioned throughput to READ: {}, WRITE: {}.", (Object)targetRead, (Object)targetWrite);
            DateTime timeout = DateTime.now().plusSeconds(300);
            int attempts = 10;
            while (DateTime.now().isBefore(timeout)) {
                try {
                    if (!this.lockBeforeIncrease()) {
                        logger.debug("Cannot acquire lock, try later");
                        this.sleep(3);
                        continue;
                    }
                    throughputSettings = this.nativeDynamoDBEntityStore.getProvisionedThroughput();
                    if (throughputSettings == null) {
                        this.sleep(3);
                        continue;
                    }
                    boolean shouldUpdate = false;
                    if (throughputSettings.getLeft() < targetRead) {
                        shouldUpdate = true;
                    } else {
                        targetRead = throughputSettings.getLeft();
                    }
                    if (throughputSettings.getRight() < targetWrite) {
                        shouldUpdate = true;
                    } else {
                        targetWrite = throughputSettings.getRight();
                    }
                    if (shouldUpdate) {
                        this.nativeDynamoDBEntityStore.setReadCapacityUnits(targetRead);
                        this.nativeDynamoDBEntityStore.setWriteCapacityUnits(targetWrite);
                        this.nativeDynamoDBEntityStore.updateProvisionedThroughput();
                        logger.info("Provisioned throughput for table {} is now READ: {}, WRITE: {}", new Object[]{this.nativeDynamoDBEntityStore.getTableName(), this.nativeDynamoDBEntityStore.getReadCapacityUnits(), this.nativeDynamoDBEntityStore.getWriteCapacityUnits()});
                    } else {
                        logger.info("Throughput has been increased to the desired value by another thread, no need to update again");
                    }
                    this.unlockAfterIncrease();
                    break;
                }
                catch (AmazonClientException e) {
                    logger.error("Error while updating provisioned throughput", (Object)e.getMessage());
                    if (--attempts > 0) continue;
                    this.updating.set(false);
                    throw e;
                }
            }
            this.updating.set(false);
        } else {
            DateTime timeout = DateTime.now().plusSeconds(300);
            while (this.updating.get()) {
                this.sleep(1);
                if (!DateTime.now().isAfter(timeout)) continue;
                logger.warn("Timeout waiting for throughput to be updated");
                this.updating.set(false);
                break;
            }
        }
    }

    private boolean shouldIncrease(int retriesAttempted) {
        return this.updating.get() || retriesAttempted >= this.maxErrorRetry;
    }

    private boolean shouldLog(int retriesAttempted) {
        return this.throttled.getAndIncrement() % 100L == 0L || retriesAttempted >= this.maxErrorRetry;
    }

    @Override
    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception.getClass().equals(ProvisionedThroughputExceededException.class)) {
            if (this.shouldLog(retriesAttempted)) {
                logger.info("Metadata access attempt {} failed due to {} on {}: {}", new Object[]{retriesAttempted, exception.getClass().getSimpleName(), originalRequest.getClass().getSimpleName(), originalRequest});
            }
            if (!this.autoIncrease) {
                return true;
            }
            DynamoDBOpType opType = this.getDynamoDBOpType(originalRequest);
            if (opType == DynamoDBOpType.READ && this.nativeDynamoDBEntityStore.getReadCapacityUnits() >= this.maxRead || opType == DynamoDBOpType.WRITE && this.nativeDynamoDBEntityStore.getWriteCapacityUnits() >= this.maxWrite || opType == DynamoDBOpType.OTHER) {
                return true;
            }
            if (this.shouldIncrease(retriesAttempted)) {
                this.autoIncrease(opType);
            }
            return true;
        }
        return retriesAttempted < this.maxErrorRetry && super.shouldRetry(originalRequest, exception, retriesAttempted);
    }

    static class UpdateLock {
        String owner;
        boolean completed;
        long timeout;

        UpdateLock(String owner, boolean completed, long timeout) {
            this.owner = owner;
            this.completed = completed;
            this.timeout = timeout;
        }

        static UpdateLock fromByteArray(byte[] bytes) {
            return new Gson().fromJson(new String(bytes), UpdateLock.class);
        }

        byte[] toByteArray() {
            return new Gson().toJson(this).getBytes();
        }
    }

    static enum DynamoDBOpType {
        READ,
        WRITE,
        OTHER;

    }
}

