/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.guice;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockFastProducerPolicy
implements RejectedExecutionHandler {
    private static final Logger logger = LoggerFactory.getLogger(BlockFastProducerPolicy.class);
    private static final int FREQUENCY_OF_LOG = 100;
    private transient long rejectedTaskIdx = 0L;

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (executor.isShutdown()) {
            throw new RejectedExecutionException("ThreadPoolExecutor already shutdown");
        }
        ++this.rejectedTaskIdx;
        if (this.rejectedTaskIdx % 100L == 1L) {
            logger.info("Waiting on the blocking worker queue");
        }
        try {
            executor.getQueue().put(r);
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException("Thread was interrupted while waiting for space to be available in the threadpool for task rtask-" + this.rejectedTaskIdx, e);
        }
    }
}

