/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.files;

import com.amazon.ws.emr.hadoop.fs.files.DeleteUtil;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Sets;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TemporaryDirectoryTracker
implements Closeable {
    private final AtomicReference<Set<Path>> trackedDirectories = new AtomicReference(Sets.newConcurrentHashSet());

    TemporaryDirectoryTracker() {
    }

    public boolean track(Path dir) {
        Set<Path> localTrackedDirectories = this.trackedDirectories.get();
        if (localTrackedDirectories == null) {
            return false;
        }
        localTrackedDirectories.add(dir);
        return true;
    }

    public boolean untrack(Path dir) {
        Set<Path> localTrackedDirectories = this.trackedDirectories.get();
        if (localTrackedDirectories == null) {
            return false;
        }
        localTrackedDirectories.remove(dir);
        return true;
    }

    @Override
    public void close() {
        Set localTrackedDirectories = this.trackedDirectories.getAndSet(null);
        if (localTrackedDirectories == null) {
            return;
        }
        for (Path directory : localTrackedDirectories) {
            DeleteUtil.recursiveDeleteIfExistsOrLog(directory);
        }
    }
}

