/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.files;

import com.amazon.ws.emr.hadoop.fs.files.DeleteUtil;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectoryShutdownHook;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.math.LongMath;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class TemporaryDirectories
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TemporaryDirectories.class);
    private final List<Path> tempDirectoryPaths;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final int initialPosition;

    TemporaryDirectories(List<Path> tempDirectoryPaths) {
        this(tempDirectoryPaths, 0);
    }

    TemporaryDirectories(List<Path> tempDirectoryPaths, int initialPosition) {
        Preconditions.checkArgument(0 <= initialPosition && initialPosition < tempDirectoryPaths.size(), "initialPosition must be a valid index");
        this.tempDirectoryPaths = ImmutableList.copyOf(tempDirectoryPaths);
        this.initialPosition = initialPosition;
    }

    private static void deletePathsRecursively(List<Path> pathsToDelete) {
        for (Path toDeleteDir : pathsToDelete) {
            if (DeleteUtil.recursiveDeleteIfExistsOrLog(toDeleteDir)) {
                TemporaryDirectoryShutdownHook.untrack(toDeleteDir);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Failed to recursively delete " + toDeleteDir + ".  Will attempt to delete this directory on exit.");
        }
    }

    public int size() {
        return this.tempDirectoryPaths.size();
    }

    public Iterator<Path> cyclingIterator() {
        return new RoundRobinIterator(this.initialPosition);
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.moveTrackAndDeleteTempDirectories();
    }

    private void moveTrackAndDeleteTempDirectories() {
        ArrayList<Path> pathsToDelete = new ArrayList<Path>(this.tempDirectoryPaths.size());
        for (Path tempDirectory : this.tempDirectoryPaths) {
            Path tempDirectoryToDelete = tempDirectory.resolveSibling(tempDirectory.getFileName() + ".todelete");
            try {
                TemporaryDirectoryShutdownHook.track(tempDirectoryToDelete);
                Files.move(tempDirectory, tempDirectoryToDelete, StandardCopyOption.ATOMIC_MOVE);
                TemporaryDirectoryShutdownHook.untrack(tempDirectory);
                pathsToDelete.add(tempDirectoryToDelete);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Could not move temporary directory: %s to %s for deletion. Falling back to non-atomic recursive delete for %s", tempDirectory, tempDirectoryToDelete, tempDirectory), (Throwable)e);
                }
                TemporaryDirectoryShutdownHook.untrack(tempDirectoryToDelete);
                pathsToDelete.add(tempDirectory);
            }
        }
        TemporaryDirectories.deletePathsRecursively(pathsToDelete);
    }

    @ThreadSafe
    private final class RoundRobinIterator
    implements Iterator<Path> {
        private final AtomicLong cursorIndex;

        RoundRobinIterator(int initialPosition) {
            this.cursorIndex = new AtomicLong(initialPosition);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Path next() {
            return (Path)TemporaryDirectories.this.tempDirectoryPaths.get(LongMath.mod(this.cursorIndex.getAndIncrement(), TemporaryDirectories.this.tempDirectoryPaths.size()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

