/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb.impl;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityUtils;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.NativeDynamoDBRateLimiter;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreExceptionCode;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.RetriableEntityStoreException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.AbstractIterator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeDynamoDBListWithPrefetchResult
implements Iterable<Entity> {
    private static final Logger logger = LoggerFactory.getLogger(NativeDynamoDBListWithPrefetchResult.class);
    private final StringBuilder lastSeenForwardRangeKey;
    private final String forwardPrefetcherName = "Forward Prefetcher";
    private final StringBuilder lastSeenBackwardRangeKey;
    private final String backwardPrefetcherName = "Backward Prefetcher";
    private Thread forwardPrefetcher;
    private BlockingDeque<QueryResult> forwardQueryResults = new LinkedBlockingDeque<QueryResult>();
    private AtomicBoolean forwardPrefetcherStopped;
    private Thread backwardPrefetcher;
    private BlockingDeque<QueryResult> backwardQueryResults;
    private AtomicBoolean backwardPrefetcherStopped;
    private String lastReturnedRangeKey = null;
    private Exception prefetcherException;
    private String lastRangeKey = null;

    public NativeDynamoDBListWithPrefetchResult(AmazonDynamoDB amazonDynamoDB, QueryRequest queryRequest, NativeDynamoDBRateLimiter rateLimiter) {
        this.lastSeenForwardRangeKey = new StringBuilder();
        this.forwardPrefetcherStopped = new AtomicBoolean(false);
        this.forwardPrefetcher = new Thread(new Prefetcher(amazonDynamoDB, queryRequest.withScanIndexForward(true), rateLimiter, this.forwardQueryResults, this.lastSeenForwardRangeKey, this.forwardPrefetcherStopped, "Forward Prefetcher"));
        this.forwardPrefetcher.setDaemon(true);
        this.forwardPrefetcher.setName("Forward Prefetcher");
        this.backwardQueryResults = new LinkedBlockingDeque<QueryResult>();
        this.lastSeenBackwardRangeKey = new StringBuilder();
        this.backwardPrefetcherStopped = new AtomicBoolean(false);
        this.backwardPrefetcher = new Thread(new Prefetcher(amazonDynamoDB, queryRequest.withScanIndexForward(false), rateLimiter, this.backwardQueryResults, this.lastSeenBackwardRangeKey, this.backwardPrefetcherStopped, "Backward Prefetcher"));
        this.backwardPrefetcher.setDaemon(true);
        this.backwardPrefetcher.setName("Backward Prefetcher");
        this.prefetcherException = null;
        this.forwardPrefetcher.start();
        this.backwardPrefetcher.start();
    }

    private String getRangeKey(Map<String, AttributeValue> item) {
        return item.get("rangeKey").getS();
    }

    private synchronized boolean isOverlapping() {
        logger.debug("Last evaluated forward range key: {}", (Object)this.lastSeenForwardRangeKey.toString());
        logger.debug("Last evaluated backward range key: {}", (Object)this.lastSeenBackwardRangeKey.toString());
        logger.debug("Number of forward query results: {}", (Object)this.forwardQueryResults.size());
        logger.debug("Number of backward query results: {}", (Object)this.backwardQueryResults.size());
        return !this.lastSeenForwardRangeKey.toString().isEmpty() && !this.lastSeenBackwardRangeKey.toString().isEmpty() && this.lastSeenForwardRangeKey.toString().compareTo(this.lastSeenBackwardRangeKey.toString()) >= 0;
    }

    private synchronized void setPrefetcherException(Exception exception) {
        this.prefetcherException = exception;
    }

    private synchronized void checkPrefetcherException() throws RuntimeException {
        if (this.prefetcherException != null) {
            throw new RuntimeException(this.prefetcherException);
        }
    }

    @Override
    public Iterator<Entity> iterator() {
        return new AbstractIterator<Entity>(){
            QueryResult queryResult = null;
            Iterator<Map<String, AttributeValue>> iterator = null;
            boolean usingBackwardResults = false;

            @Override
            protected Entity computeNext() {
                if (NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey != null && NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey.equals(NativeDynamoDBListWithPrefetchResult.this.lastRangeKey)) {
                    return (Entity)this.endOfData();
                }
                block6: while (true) {
                    String lowerRangeKey;
                    NativeDynamoDBListWithPrefetchResult.this.checkPrefetcherException();
                    if (this.iterator != null && this.iterator.hasNext()) break;
                    if (NativeDynamoDBListWithPrefetchResult.this.forwardQueryResults.isEmpty() && NativeDynamoDBListWithPrefetchResult.this.backwardQueryResults.isEmpty()) {
                        if (!NativeDynamoDBListWithPrefetchResult.this.forwardPrefetcherStopped.get() || !NativeDynamoDBListWithPrefetchResult.this.backwardPrefetcherStopped.get()) continue;
                        return (Entity)this.endOfData();
                    }
                    if (!NativeDynamoDBListWithPrefetchResult.this.forwardQueryResults.isEmpty()) {
                        try {
                            this.queryResult = (QueryResult)NativeDynamoDBListWithPrefetchResult.this.forwardQueryResults.take();
                            List<Map<String, AttributeValue>> items = this.queryResult.getItems();
                            logger.debug("Getting items from forwardQueryResults: {} - {}", (Object)NativeDynamoDBListWithPrefetchResult.this.getRangeKey(items.get(0)), (Object)NativeDynamoDBListWithPrefetchResult.this.getRangeKey(items.get(items.size() - 1)));
                            this.iterator = this.queryResult.getItems().iterator();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (!NativeDynamoDBListWithPrefetchResult.this.forwardQueryResults.isEmpty() || NativeDynamoDBListWithPrefetchResult.this.backwardQueryResults.isEmpty() || !NativeDynamoDBListWithPrefetchResult.this.forwardPrefetcherStopped.get() || !NativeDynamoDBListWithPrefetchResult.this.forwardQueryResults.isEmpty() || !NativeDynamoDBListWithPrefetchResult.this.backwardPrefetcherStopped.get()) continue;
                    if (NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey == null) {
                        NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey = "";
                        this.usingBackwardResults = true;
                    }
                    QueryResult result = null;
                    if (!this.usingBackwardResults) {
                        lowerRangeKey = "";
                        String upperRangeKey = "";
                        while (!NativeDynamoDBListWithPrefetchResult.this.backwardQueryResults.isEmpty()) {
                            try {
                                result = (QueryResult)NativeDynamoDBListWithPrefetchResult.this.backwardQueryResults.takeLast();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            lowerRangeKey = NativeDynamoDBListWithPrefetchResult.this.getRangeKey(result.getItems().get(result.getItems().size() - 1));
                            upperRangeKey = NativeDynamoDBListWithPrefetchResult.this.getRangeKey(result.getItems().get(0));
                            if (NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey.compareTo(lowerRangeKey) >= 0 && NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey.compareTo(upperRangeKey) < 0) break;
                            result = null;
                        }
                        if (result == null) {
                            logger.info("Cannot find the next item {} in backwardQueryResults", (Object)NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey);
                            return (Entity)this.endOfData();
                        }
                        this.iterator = Lists.reverse(result.getItems()).iterator();
                        do {
                            if (!this.iterator.hasNext()) continue block6;
                        } while (!NativeDynamoDBListWithPrefetchResult.this.getRangeKey(this.iterator.next()).equals(NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey));
                        logger.debug("Last range key from forwardQueryResults: {}", (Object)NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey);
                        logger.debug("Start getting items from backwardQueryResults: {} - {}", (Object)lowerRangeKey, (Object)upperRangeKey);
                        this.usingBackwardResults = true;
                        continue;
                    }
                    while (!NativeDynamoDBListWithPrefetchResult.this.backwardQueryResults.isEmpty()) {
                        try {
                            result = (QueryResult)NativeDynamoDBListWithPrefetchResult.this.backwardQueryResults.takeLast();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        lowerRangeKey = NativeDynamoDBListWithPrefetchResult.this.getRangeKey(result.getItems().get(result.getItems().size() - 1));
                        if (lowerRangeKey.compareTo(NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey) >= 0) break;
                        result = null;
                    }
                    if (result == null) {
                        return (Entity)this.endOfData();
                    }
                    logger.debug("Getting items from backwardQueryResults: {} - {}", (Object)NativeDynamoDBListWithPrefetchResult.this.getRangeKey(result.getItems().get(result.getItems().size() - 1)), (Object)NativeDynamoDBListWithPrefetchResult.this.getRangeKey(result.getItems().get(0)));
                    this.iterator = Lists.reverse(result.getItems()).iterator();
                }
                Map<String, AttributeValue> item = this.iterator.next();
                Entity entity = EntityUtils.itemToEntity(this.iterator.next());
                NativeDynamoDBListWithPrefetchResult.this.lastReturnedRangeKey = item.get("rangeKey").getS();
                return entity;
            }
        };
    }

    class Prefetcher
    implements Runnable {
        private AmazonDynamoDB amazonDynamoDB;
        private QueryRequest queryRequest;
        private Map<String, AttributeValue> exclusiveStartKey = null;
        private NativeDynamoDBRateLimiter rateLimiter;
        private BlockingDeque<QueryResult> queryResults;
        private StringBuilder lastSeenRangeKey;
        private AtomicBoolean stopped;
        private String prefetcherName;

        Prefetcher(AmazonDynamoDB amazonDynamoDB, QueryRequest queryRequest, NativeDynamoDBRateLimiter rateLimiter, BlockingDeque<QueryResult> queryResults, StringBuilder lastSeenRangeKey, AtomicBoolean stopped, String prefetcherName) {
            this.prefetcherName = prefetcherName;
            this.amazonDynamoDB = amazonDynamoDB;
            this.queryRequest = new QueryRequest().withTableName(queryRequest.getTableName()).withConsistentRead(queryRequest.getConsistentRead()).withKeyConditions(queryRequest.getKeyConditions()).withLimit(queryRequest.getLimit()).withScanIndexForward(queryRequest.getScanIndexForward()).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
            this.rateLimiter = rateLimiter;
            this.queryResults = queryResults;
            this.lastSeenRangeKey = lastSeenRangeKey;
            this.stopped = stopped;
        }

        @Override
        public void run() {
            block10: {
                do {
                    QueryResult queryResult;
                    block11: {
                        this.queryRequest.setExclusiveStartKey(this.exclusiveStartKey);
                        try {
                            this.rateLimiter.beforeRead();
                            queryResult = this.amazonDynamoDB.query(this.queryRequest);
                            this.rateLimiter.afterRead(queryResult.getConsumedCapacity());
                        }
                        catch (AmazonClientException e) {
                            String errorMessage = String.format("Query operation failed: '%s'", this.queryRequest);
                            NativeDynamoDBListWithPrefetchResult.this.setPrefetcherException(new RetriableEntityStoreException(errorMessage, e, EntityStoreExceptionCode.AMAZON_CLIENT_EXCEPTION));
                            this.stopped.set(true);
                            break block10;
                        }
                        if (queryResult == null || queryResult.getItems() == null || queryResult.getItems().size() == 0) {
                            this.stopped.set(true);
                            break block10;
                        }
                        try {
                            if (this.prefetcherName.equals("Forward Prefetcher")) {
                                logger.debug("{} fetched range keys {} - {}", new Object[]{this.prefetcherName, NativeDynamoDBListWithPrefetchResult.this.getRangeKey(queryResult.getItems().get(0)), NativeDynamoDBListWithPrefetchResult.this.getRangeKey(queryResult.getItems().get(queryResult.getItems().size() - 1))});
                            } else {
                                logger.debug("{} fetched range keys {} - {}", new Object[]{this.prefetcherName, NativeDynamoDBListWithPrefetchResult.this.getRangeKey(queryResult.getItems().get(queryResult.getItems().size() - 1)), NativeDynamoDBListWithPrefetchResult.this.getRangeKey(queryResult.getItems().get(0))});
                            }
                            Map<String, AttributeValue> item = queryResult.getItems().get(queryResult.getItems().size() - 1);
                            if (this.queryRequest.getScanIndexForward().booleanValue() && queryResult.getLastEvaluatedKey() == null) {
                                NativeDynamoDBListWithPrefetchResult.this.lastRangeKey = NativeDynamoDBListWithPrefetchResult.this.getRangeKey(item);
                            }
                            this.queryResults.putLast(queryResult);
                            this.lastSeenRangeKey.setLength(0);
                            this.lastSeenRangeKey.append(NativeDynamoDBListWithPrefetchResult.this.getRangeKey(item));
                            if (NativeDynamoDBListWithPrefetchResult.this.isOverlapping()) {
                                this.stopped.set(true);
                            }
                            break block11;
                        }
                        catch (InterruptedException e) {
                            NativeDynamoDBListWithPrefetchResult.this.setPrefetcherException(e);
                            this.stopped.set(true);
                        }
                        break block10;
                    }
                    this.exclusiveStartKey = queryResult.getLastEvaluatedKey();
                } while (this.exclusiveStartKey != null);
                this.stopped.set(true);
            }
        }
    }
}

