/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb.impl;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityUtils;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.NativeDynamoDBRateLimiter;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreExceptionCode;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.RetriableEntityStoreException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.AbstractIterator;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeDynamoDBListResult
implements Iterable<Entity> {
    private static final Logger logger = LoggerFactory.getLogger(NativeDynamoDBListResult.class);
    private final QueryRequest queryRequest;
    private final AmazonDynamoDB amazonDynamoDB;
    private Map<String, AttributeValue> exclusiveStartKey = null;
    private boolean endOfData = false;
    private NativeDynamoDBRateLimiter rateLimiter;

    public NativeDynamoDBListResult(AmazonDynamoDB amazonDynamoDB, QueryRequest queryRequest, NativeDynamoDBRateLimiter rateLimiter) {
        this.amazonDynamoDB = amazonDynamoDB;
        this.queryRequest = queryRequest;
        this.rateLimiter = rateLimiter;
    }

    @Override
    public Iterator<Entity> iterator() {
        return new AbstractIterator<Entity>(){
            List<Entity> batchResult = null;
            Iterator<Entity> iterator = null;

            @Override
            protected Entity computeNext() {
                while (this.iterator == null || !this.iterator.hasNext()) {
                    this.batchResult = NativeDynamoDBListResult.this.getNextBatch();
                    if (this.batchResult == null || this.batchResult.size() == 0) {
                        return (Entity)this.endOfData();
                    }
                    this.iterator = this.batchResult.iterator();
                }
                return this.iterator.next();
            }
        };
    }

    private List<Entity> getNextBatch() {
        QueryResult queryResult;
        if (this.endOfData) {
            return null;
        }
        this.queryRequest.setExclusiveStartKey(this.exclusiveStartKey);
        try {
            this.rateLimiter.beforeRead();
            queryResult = this.amazonDynamoDB.query(this.queryRequest);
            this.rateLimiter.afterRead(queryResult.getConsumedCapacity());
        }
        catch (AmazonClientException e) {
            logger.error(String.format("Query operation failed: '%s'", this.queryRequest), (Throwable)e);
            throw new RetriableEntityStoreException(e, EntityStoreExceptionCode.AMAZON_CLIENT_EXCEPTION);
        }
        if (queryResult == null || queryResult.getItems() == null || queryResult.getItems().size() == 0) {
            this.endOfData = true;
            return null;
        }
        this.exclusiveStartKey = queryResult.getLastEvaluatedKey();
        if (this.exclusiveStartKey == null) {
            this.endOfData = true;
        }
        ArrayList<Entity> entities = Lists.newArrayList();
        for (Map<String, AttributeValue> item : queryResult.getItems()) {
            entities.add(EntityUtils.itemToEntity(item));
        }
        return entities;
    }
}

