/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb.impl;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKeyCondition;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.DynamoDBUtils;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreExceptionCode;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryEntityStore
implements EntityStore<Entity> {
    private final ConcurrentSkipListMap<ItemKey, Entity> db = new ConcurrentSkipListMap();
    private final long atomicCounterInitialValue = 1L;
    private boolean conditionalUpdate = false;
    private String tableName;

    public InMemoryEntityStore withConditionalUpdate(boolean conditionalUpdate) {
        this.setConditionalUpdate(conditionalUpdate);
        return this;
    }

    @Override
    public synchronized void create(Entity entity) throws EntityStoreException {
        DynamoDBUtils.validateItemKey(entity, "Create");
        Preconditions.checkNotNull(entity.getPayload(), "must supply a payload");
        Preconditions.checkArgument(entity.getPayload().length > 0, "payload must have positive size");
        if (this.db.containsKey(entity.getItemKey())) {
            throw new EntityStoreException(String.format("Item already exists: '%s'", entity.getItemKey()), EntityStoreExceptionCode.ALREADY_EXISTS);
        }
        Entity copy = new Entity(entity);
        copy.setLastModified(DateTime.now().getMillis());
        copy.setCounter(this.conditionalUpdate ? Long.valueOf(1L) : null);
        copy.setDeletionTTL(0L);
        if (copy.getPayload() == null) {
            copy.setPayload(new byte[0]);
        }
        this.db.put(copy.getItemKey(), copy);
    }

    @Override
    public synchronized void create(Collection<Entity> entities) {
        Preconditions.checkNotNull(entities, "entities must have a value");
        for (Entity e : entities) {
            Preconditions.checkNotNull(e, "entity must have a value");
        }
        for (Entity e : entities) {
            this.create(e);
        }
    }

    @Override
    public synchronized void update(Entity entity) throws EntityStoreException {
        DynamoDBUtils.validateItemKey(entity, "Update");
        if (!this.db.containsKey(entity.getItemKey())) {
            throw new EntityStoreException(String.format("Item doesn't already exist: '%s'", entity.getItemKey()), EntityStoreExceptionCode.STALE_ENTITY);
        }
        Entity existing = this.db.get(entity.getItemKey());
        if (this.conditionalUpdate && entity.getCounter() != existing.getCounter()) {
            throw new EntityStoreException(String.format("Stale data: '%s'", entity), EntityStoreExceptionCode.STALE_ENTITY);
        }
        existing.setLastModified(DateTime.now().getMillis());
        existing.setPayload(entity.getPayload() == null ? new byte[]{} : entity.getPayload());
        existing.setDeletionTTL(entity.getDeletionTTL());
        if (this.conditionalUpdate) {
            existing.setCounter(existing.getCounter() == null ? 1L : existing.getCounter() + 1L);
        }
    }

    @Override
    public Entity retrieve(ItemKey itemKey) {
        DynamoDBUtils.validateItemKey(itemKey, "Retrieve");
        return this.db.get(itemKey) == null ? null : new Entity(this.db.get(itemKey));
    }

    @Override
    public synchronized void delete(Entity entity) throws EntityStoreException {
        DynamoDBUtils.validateItemKey(entity, "Delete");
        if (!this.db.containsKey(entity.getItemKey())) {
            return;
        }
        Entity existing = this.db.get(entity.getItemKey());
        if (this.conditionalUpdate && entity.getCounter() != existing.getCounter()) {
            throw new EntityStoreException(String.format("Stale data: '%s'", entity), EntityStoreExceptionCode.STALE_ENTITY);
        }
        this.db.remove(entity.getItemKey());
    }

    @Override
    public synchronized void delete(ItemKey itemKey) throws EntityStoreException {
        this.delete(new Entity(itemKey));
    }

    @Override
    public synchronized void delete(Collection<ItemKey> itemKeys) throws EntityStoreException {
        Preconditions.checkNotNull(itemKeys, "itemKeys must have a value");
        for (ItemKey itemKey : itemKeys) {
            Preconditions.checkNotNull(itemKey, "itemKey must have a value");
        }
        for (ItemKey itemKey : itemKeys) {
            DynamoDBUtils.validateItemKey(itemKey, "Delete");
            if (!this.db.containsKey(itemKey)) {
                return;
            }
            this.db.remove(itemKey);
        }
    }

    @Override
    public Iterable<Entity> dump() {
        ArrayList<Entity> results = new ArrayList<Entity>(this.db.values().size());
        results.addAll(this.db.values());
        return results;
    }

    @Override
    public Iterable<Entity> dump(ItemKeyCondition condition) {
        String conditionalRangeKey = condition.getItemKey().getRangeKey();
        String conditionalHashKey = condition.getItemKey().getHashKey();
        return Iterables.filter(this.dump(), input -> {
            ItemKey itemKey = input.getItemKey();
            switch (condition.getCondition()) {
                case BEGINS_WITH: {
                    if (!Strings.isNullOrEmpty(conditionalRangeKey) && !itemKey.getRangeKey().startsWith(conditionalRangeKey)) {
                        return false;
                    }
                    return itemKey.getHashKey().startsWith(conditionalHashKey);
                }
                case EQUALS: {
                    if (!Strings.isNullOrEmpty(conditionalRangeKey) && !itemKey.getRangeKey().equals(conditionalRangeKey)) {
                        return false;
                    }
                    return itemKey.getHashKey().equals(conditionalHashKey);
                }
            }
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public Iterable<Entity> list(ItemKey itemKey) {
        Preconditions.checkNotNull(itemKey, "Item key cannot be null");
        if (!Strings.isNullOrEmpty(itemKey.getRangeKey())) {
            ArrayList<Entity> ret = Lists.newArrayList();
            if (this.db.containsKey(itemKey)) {
                ret.add(new Entity(this.db.get(itemKey)));
            }
            return ret;
        }
        ItemKey startKey = new ItemKey(itemKey.getHashKey(), "");
        StringBuilder nextHashKeyBuilder = new StringBuilder(itemKey.getHashKey());
        nextHashKeyBuilder.append('\u0000');
        ItemKey endKey = new ItemKey(nextHashKeyBuilder.toString(), "");
        return this.list(startKey, true, endKey, false);
    }

    @Override
    public Iterable<Entity> list(ItemKey startKey, boolean startKeyInclusive, ItemKey endKey, boolean endKeyInclusive) {
        Preconditions.checkNotNull(startKey, "Start key cannot be null");
        Preconditions.checkNotNull(endKey, "End key cannot be null");
        ArrayList<Entity> ret = Lists.newArrayList();
        for (Entity entity : this.db.subMap((Object)startKey, startKeyInclusive, (Object)endKey, endKeyInclusive).values()) {
            ret.add(new Entity(entity));
        }
        return ret;
    }

    @Override
    public void close() {
    }

    public void setConditionalUpdate(boolean conditionalUpdate) {
        this.conditionalUpdate = conditionalUpdate;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

