/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb.impl;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;

public final class DynamoDBUtils {
    public static Long getLongFromItemIfExists(AttributeValue attributeValue) {
        if (attributeValue == null || attributeValue.getN() == null || attributeValue.getN().length() == 0) {
            return 0L;
        }
        return Long.parseLong(attributeValue.getN());
    }

    public static void validateItemKey(Entity entity, String callerName) {
        Preconditions.checkNotNull(entity, "Entity cannot be null");
        DynamoDBUtils.validateItemKey(entity.getItemKey(), callerName);
    }

    public static void validateItemKey(ItemKey itemKey, String callerName) {
        Preconditions.checkNotNull(itemKey, "Item key cannot be null");
        String hashKey = itemKey.getHashKey();
        String rangeKey = itemKey.getRangeKey();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hashKey), callerName + ": hash key cannot be empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(rangeKey), callerName + ": range key cannot be empty");
    }

    private DynamoDBUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

