/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.dynamodb;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.DynamoDBUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.Map;

public final class EntityUtils {
    public static Entity itemToEntity(Map<String, AttributeValue> item) {
        String hashKey = item.get("hashKey").getS();
        String rangeKey = item.get("rangeKey").getS();
        Long lastModified = Long.parseLong(item.get("lastModified").getN());
        byte[] payload = item.get("payload").getB().array();
        Long deletionTTL = DynamoDBUtils.getLongFromItemIfExists(item.get("deletionTTL"));
        Entity entity = new Entity(new ItemKey(hashKey, rangeKey)).withLastModified(lastModified).withPayload(payload).withDeletionTTL(deletionTTL);
        if (item.containsKey("counter")) {
            Long counter = Long.parseLong(item.get("counter").getN());
            entity = entity.withCounter(counter);
        }
        if (item.containsKey("eTag")) {
            entity = entity.withEtag(item.get("eTag").getS());
        }
        return entity;
    }

    private EntityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

