/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.cse;

import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.AbortMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.CompleteMultipartUploadEvent;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MultipartUploadDispatcher;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeferMultipartUploadDispatcher
implements MultipartUploadDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(DeferMultipartUploadDispatcher.class);
    @NonNull
    private final MultipartUploadDispatcher uploadDispatcher;
    private final AtomicReference<Deferral> deferral = new AtomicReference<Deferral>(DeferMultipartUploadDispatcher.newInitializedDeferral());

    @Override
    public void complete(@NonNull CompleteMultipartUploadEvent event) throws IOException {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        Deferral oldDeferral = this.getAndUpdateDeferralToPendingIfInitialized(event);
        if (!oldDeferral.isInitialized()) {
            throw new IOException(String.format("Cannot defer complete event on unexpected state. Expected: [INITIALIZED]; Actual: [%s]", new Object[]{oldDeferral.getState()}));
        }
        logger.debug("Deferred complete event for key {}", (Object)event.getKey());
    }

    @Override
    public void abort(@NonNull AbortMultipartUploadEvent event) throws IOException {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.uploadDispatcher.abort(event);
    }

    void resumeCompleteOrAbortOnFailure() throws IOException {
        Deferral oldDeferral = this.getAndUpdateDeferralToResumingIfPending();
        if (!oldDeferral.isPending()) {
            throw new IOException(String.format("Cannot resume complete event on unexpected state. Expected: [PENDING]; Actual: [%s]", new Object[]{oldDeferral.getState()}));
        }
        this.resumeOrAbortIfFails(oldDeferral);
    }

    void cancelDeferral() throws IOException {
        Deferral oldDeferral = this.getAndUpdateDeferralToCancelledIfShouldCancel();
        switch (oldDeferral.getState()) {
            case CANCELLED: {
                return;
            }
            case INITIALIZED: {
                return;
            }
            case PENDING: {
                this.abort(this.toAbortEvent(oldDeferral.getEvent()));
                break;
            }
            default: {
                throw new IOException(String.format("Cannot cancel deferral on unexpected state. Expected: [INITIALIZED, PENDING]; Actual: [%s]", new Object[]{oldDeferral.getState()}));
            }
        }
    }

    private Deferral getAndUpdateDeferralToCancelledIfShouldCancel() {
        return this.deferral.getAndUpdate(old -> this.shouldCancelDeferral((Deferral)old) ? DeferMultipartUploadDispatcher.newCancelledDeferral() : old);
    }

    private boolean shouldCancelDeferral(Deferral deferral) {
        return deferral.getState() == Deferral.State.INITIALIZED || deferral.getState() == Deferral.State.PENDING;
    }

    private Deferral getAndUpdateDeferralToPendingIfInitialized(CompleteMultipartUploadEvent event) {
        return this.deferral.getAndUpdate(old -> ((Deferral)old).isInitialized() ? DeferMultipartUploadDispatcher.newPendingDeferral(event) : old);
    }

    private Deferral getAndUpdateDeferralToResumingIfPending() {
        return this.deferral.getAndUpdate(old -> ((Deferral)old).isPending() ? DeferMultipartUploadDispatcher.newResumingDeferral() : old);
    }

    private void resumeOrAbortIfFails(Deferral oldDeferral) throws IOException {
        try {
            this.dispatchDeferredCompleteEvent(oldDeferral.getEvent());
            this.deferral.set(DeferMultipartUploadDispatcher.newResumedDeferral());
        }
        catch (IOException | RuntimeException e) {
            this.deferral.set(DeferMultipartUploadDispatcher.newResumeFailedDeferral());
            this.abortUploadOrAddSuppressedIfFailed(oldDeferral, e);
            throw e;
        }
    }

    private void abortUploadOrAddSuppressedIfFailed(Deferral deferral, Exception e) {
        try {
            this.abortUpload(deferral.getEvent());
        }
        catch (IOException | RuntimeException abortException) {
            e.addSuppressed(abortException);
        }
    }

    private void dispatchDeferredCompleteEvent(CompleteMultipartUploadEvent event) throws IOException {
        this.uploadDispatcher.complete(event);
        logger.debug("Resumed complete event for key {}", (Object)event.getKey());
    }

    private void abortUpload(CompleteMultipartUploadEvent event) throws IOException {
        this.abort(this.toAbortEvent(event));
    }

    private AbortMultipartUploadEvent toAbortEvent(CompleteMultipartUploadEvent event) {
        return AbortMultipartUploadEvent.builder().uploadId(event.getUploadId()).key(event.getKey()).bucket(event.getBucket()).build();
    }

    private static Deferral newPendingDeferral(CompleteMultipartUploadEvent event) {
        return new Deferral(Deferral.State.PENDING, event);
    }

    private static Deferral newInitializedDeferral() {
        return DeferMultipartUploadDispatcher.newDeferralWithNullEvent(Deferral.State.INITIALIZED);
    }

    private static Deferral newResumingDeferral() {
        return DeferMultipartUploadDispatcher.newDeferralWithNullEvent(Deferral.State.RESUMING);
    }

    private static Deferral newResumedDeferral() {
        return DeferMultipartUploadDispatcher.newDeferralWithNullEvent(Deferral.State.RESUMED);
    }

    private static Deferral newResumeFailedDeferral() {
        return DeferMultipartUploadDispatcher.newDeferralWithNullEvent(Deferral.State.RESUME_FAILED);
    }

    private static Deferral newCancelledDeferral() {
        return DeferMultipartUploadDispatcher.newDeferralWithNullEvent(Deferral.State.CANCELLED);
    }

    private static Deferral newDeferralWithNullEvent(Deferral.State state) {
        return new Deferral(state, null);
    }

    public DeferMultipartUploadDispatcher(@NonNull MultipartUploadDispatcher uploadDispatcher) {
        if (uploadDispatcher == null) {
            throw new NullPointerException("uploadDispatcher is marked non-null but is null");
        }
        this.uploadDispatcher = uploadDispatcher;
    }

    private static final class Deferral {
        private final State state;
        private final CompleteMultipartUploadEvent event;

        private boolean isInitialized() {
            return this.state == State.INITIALIZED;
        }

        private boolean isPending() {
            return this.state == State.PENDING;
        }

        public Deferral(State state, CompleteMultipartUploadEvent event) {
            this.state = state;
            this.event = event;
        }

        public State getState() {
            return this.state;
        }

        public CompleteMultipartUploadEvent getEvent() {
            return this.event;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Deferral)) {
                return false;
            }
            Deferral other = (Deferral)o;
            State this$state = this.getState();
            State other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            CompleteMultipartUploadEvent this$event = this.getEvent();
            CompleteMultipartUploadEvent other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            State $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            CompleteMultipartUploadEvent $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            return result;
        }

        public String toString() {
            return "DeferMultipartUploadDispatcher.Deferral(state=" + (Object)((Object)this.getState()) + ", event=" + this.getEvent() + ")";
        }

        private static enum State {
            INITIALIZED,
            PENDING,
            RESUMING,
            RESUME_FAILED,
            RESUMED,
            CANCELLED;

        }
    }
}

