/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.cse;

import com.amazon.ws.emr.hadoop.fs.cse.CSEUploadObjectObserver;
import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.cse.DeferMultipartUploadDispatcher;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectories;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLite;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadConstraint;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.event.ProgressListener;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.UploadObjectObserver;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.internal.MultiFileOutputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Throwables;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.IOUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.Seconds;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.common.Abortable;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSEMultipartUploadOutputStream
extends PipedOutputStream
implements Abortable {
    private static final Logger logger = LoggerFactory.getLogger(CSEMultipartUploadOutputStream.class);
    private static final long PART_SIZE_DEFAULT = 0x8000000L;
    private static final long S3_MIN_PART_SIZE = 0x500000L;
    private static final long CLOSE_LOG_INTERVAL = 180000L;
    private static final int CLOSE_LOG_COUNT = 10;
    private static final int PIS_BUF_SIZE = 0x100000;
    private final AmazonS3EncryptionLite s3;
    private final String bucket;
    private final String key;
    private final String s3path;
    private final ObjectMetadata metadata;
    private final Configuration conf;
    private final Progressable progress;
    private final ProgressListener progressListener;
    private final ExecutorService exec;
    private final DateTime startTime;
    private final UploadObjectObserver observer;
    private final PipedInputStream pis;
    private final TemporaryDirectories directories;
    private final Iterator<Path> directoryIterator;
    private final AtomicLong namePrefixSequence = new AtomicLong(0L);
    private final AtomicLong totalLength;
    private final DeferMultipartUploadDispatcher uploadDispatcher;
    private long partSize;
    private Thread uploader;
    private SingleThreadExceptionCatcher exceptionCatcher;
    private boolean closed = false;

    public CSEMultipartUploadOutputStream(AmazonS3EncryptionLite s3, UploadPlan uploadPlan, Configuration conf, Progressable progress, ExecutorService exec, TemporaryDirectories directories) throws IOException {
        CSEMultipartUploadOutputStream.checkUploadPlanConstraint(uploadPlan);
        this.s3 = s3;
        this.bucket = uploadPlan.getBucket();
        this.key = uploadPlan.getKey();
        this.s3path = "s3://" + this.bucket + "/" + this.key;
        this.metadata = new ObjectMetadata();
        this.metadata.setContentType("binary/octet-stream");
        this.partSize = conf.getLong("fs.s3n.multipart.uploads.split.size", 0x8000000L);
        if (this.partSize < 0x500000L) {
            logger.warn("fs.s3n.multipart.uploads.split.size = " + this.partSize + " is too small, setting to min " + 0x500000L);
            this.partSize = 0x500000L;
        }
        this.conf = conf;
        this.progress = progress;
        this.progressListener = this.progress != null ? progressEvent -> this.progress.progress() : null;
        this.exec = exec;
        this.startTime = DateTime.now();
        this.totalLength = new AtomicLong(0L);
        this.uploadDispatcher = new DeferMultipartUploadDispatcher(uploadPlan.getMultipartDispatcher());
        this.observer = CSEUploadObjectObserver.builder().totalLengthSupplier(this.totalLength::get).extraUploadMetadata(uploadPlan.getExtraUploadMetadata()).dispatcher(this.uploadDispatcher).progressListener(this.progressListener).build();
        this.pis = new PipedInputStream(this, 0x100000);
        this.exceptionCatcher = new SingleThreadExceptionCatcher();
        this.directories = directories;
        this.directoryIterator = directories.cyclingIterator();
        this.init();
    }

    private static void checkUploadPlanConstraint(UploadPlan uploadPlan) {
        if (uploadPlan.getConstraint() == UploadConstraint.SINGLE_PART_UPLOAD) {
            throw new UnsupportedOperationException("Single part upload is not supported in current output stream");
        }
    }

    private static void throwIOExceptionOrWrap(Exception e) throws IOException {
        Throwables.propagateIfInstanceOf(e, IOException.class);
        throw new IOException(e);
    }

    private String getNextNamePrefix() {
        return String.format("%010d", this.namePrefixSequence.getAndIncrement());
    }

    private void init() {
        this.uploader = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UploadObjectRequest req = new UploadObjectRequest(CSEMultipartUploadOutputStream.this.bucket, CSEMultipartUploadOutputStream.this.key, CSEMultipartUploadOutputStream.this.pis, CSEMultipartUploadOutputStream.this.metadata).withMaterialsDescription(CSEUtils.getMaterialsDescription(CSEMultipartUploadOutputStream.this.conf, S3UriUtils.getPathForS3Object(CSEMultipartUploadOutputStream.this.bucket, CSEMultipartUploadOutputStream.this.key)));
                    CannedAccessControlList acl = ConfigurationUtils.getAcl(CSEMultipartUploadOutputStream.this.conf);
                    if (acl != null) {
                        req.setCannedAcl(acl);
                    }
                    req.withUploadObjectObserver(CSEMultipartUploadOutputStream.this.observer);
                    req.withExecutorService(CSEMultipartUploadOutputStream.this.exec);
                    req.withPartSize(CSEMultipartUploadOutputStream.this.partSize);
                    req.withMultiFileOutputStream(new MultiFileOutputStream(((Path)CSEMultipartUploadOutputStream.this.directoryIterator.next()).toFile(), CSEMultipartUploadOutputStream.this.getNextNamePrefix()));
                    CSEMultipartUploadOutputStream.this.s3.uploadObject(req);
                }
                catch (Exception e) {
                    logger.error("failed to upload object {}/{}, trying to close piped input stream.", (Object)CSEMultipartUploadOutputStream.this.bucket, (Object)CSEMultipartUploadOutputStream.this.key);
                    throw new RuntimeException(e);
                }
                finally {
                    IOUtils.closeQuietly(CSEMultipartUploadOutputStream.this.pis);
                }
            }
        });
        this.uploader.setName("CseMpuWorker");
        this.uploader.setDaemon(true);
        this.uploader.setUncaughtExceptionHandler(this.exceptionCatcher);
        this.uploader.start();
    }

    @Override
    public void close() throws IOException {
        block11: {
            logger.info("close closed:" + this.closed + " " + this.s3path);
            if (this.closed) {
                return;
            }
            super.close();
            if (this.uploader != null) {
                try {
                    for (int i = 0; i < 10; ++i) {
                        this.uploader.join(180000L);
                        if (!this.uploader.isAlive()) break;
                        logger.debug("Still uploading {}/{}. Elapsed seconds: {}.", new Object[]{this.bucket, this.key, Seconds.secondsBetween(this.startTime, DateTime.now()).getSeconds()});
                    }
                    if (this.uploader.isAlive()) {
                        logger.info("Still uploading {}/{}. Elapsed seconds: {}.", new Object[]{this.bucket, this.key, Seconds.secondsBetween(this.startTime, DateTime.now()).getSeconds()});
                        this.uploader.join();
                    }
                    if (this.exceptionCatcher.isEmpty()) {
                        this.uploadDispatcher.resumeCompleteOrAbortOnFailure();
                        logger.info("Finished uploading {}/{}. Elapsed seconds: {}.", new Object[]{this.bucket, this.key, Seconds.secondsBetween(this.startTime, DateTime.now()).getSeconds()});
                        break block11;
                    }
                    throw new IOException("Error closing multipart upload", this.exceptionCatcher.getThrowable());
                }
                catch (InterruptedException e) {
                    this.cancelDeferralOrAddSuppressedIfFails(e);
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                catch (IOException | RuntimeException e) {
                    this.cancelDeferralOrAddSuppressedIfFails(e);
                    CSEMultipartUploadOutputStream.throwIOExceptionOrWrap(e);
                }
                finally {
                    this.directories.close();
                }
            }
        }
        this.closed = true;
    }

    private void cancelDeferralOrAddSuppressedIfFails(Exception e) {
        try {
            this.uploadDispatcher.cancelDeferral();
        }
        catch (IOException | RuntimeException abortException) {
            e.addSuppressed(abortException);
        }
    }

    public void abort() throws IOException {
        logger.info("Aborting upload {}/{}.", (Object)this.bucket, (Object)this.key);
        try {
            this.observer.onAbort();
            this.pis.close();
            super.close();
        }
        finally {
            this.directories.close();
        }
        this.closed = true;
    }

    @Override
    public void write(int singleByte) throws IOException {
        super.write(singleByte);
        this.totalLength.getAndIncrement();
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        super.write(bytes, off, len);
        this.totalLength.getAndAdd(len);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    private static final class SingleThreadExceptionCatcher
    implements Thread.UncaughtExceptionHandler {
        private Throwable throwable;

        private SingleThreadExceptionCatcher() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            if (this.throwable != null && this.throwable != exception) {
                exception.addSuppressed(this.throwable);
            }
            this.throwable = exception;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        private boolean isEmpty() {
            return this.throwable == null;
        }
    }
}

