/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency.concurrent;

import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import javax.annotation.Nullable;

public final class ConcurrencyToken {
    private final boolean entityExistent;
    private final Long counter;

    public static ConcurrencyToken of(@Nullable Entity entity) {
        return entity == null ? ConcurrencyToken.ofNonexistentEntity() : ConcurrencyToken.ofEntityWithCounter(entity.getCounter());
    }

    public static ConcurrencyToken ofNonexistentEntity() {
        return new ConcurrencyToken(false, null);
    }

    public static ConcurrencyToken ofEntityWithoutCounter() {
        return ConcurrencyToken.ofEntityWithCounter(null);
    }

    public static ConcurrencyToken ofEntityWithCounter(Long counter) {
        return new ConcurrencyToken(true, counter);
    }

    public boolean isEntityExistent() {
        return this.entityExistent;
    }

    public Long getCounter() {
        return this.counter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConcurrencyToken)) {
            return false;
        }
        ConcurrencyToken other = (ConcurrencyToken)o;
        if (this.isEntityExistent() != other.isEntityExistent()) {
            return false;
        }
        Long this$counter = this.getCounter();
        Long other$counter = other.getCounter();
        return !(this$counter == null ? other$counter != null : !((Object)this$counter).equals(other$counter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEntityExistent() ? 79 : 97);
        Long $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : ((Object)$counter).hashCode());
        return result;
    }

    public String toString() {
        return "ConcurrencyToken(entityExistent=" + this.isEntityExistent() + ", counter=" + this.getCounter() + ")";
    }

    private ConcurrencyToken(boolean entityExistent, Long counter) {
        this.entityExistent = entityExistent;
        this.counter = counter;
    }
}

