/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.EmrFsStore;
import lombok.NonNull;

public final class MetadataFiles {
    public static final EmrFsStore.MetadataFile DISCOVERED_FILE = MetadataFiles.fileWithState(EmrFsStore.MetadataFile.State.DISCOVERED);
    public static final EmrFsStore.MetadataFile PLACED_FILE = MetadataFiles.fileWithState(EmrFsStore.MetadataFile.State.PUT);
    public static final EmrFsStore.MetadataFile DELETED_FILE = MetadataFiles.fileWithState(EmrFsStore.MetadataFile.State.DELETED);
    public static final EmrFsStore.MetadataFile DISCOVERED_DIRECTORY = MetadataFiles.directoryWithState(EmrFsStore.MetadataFile.State.DISCOVERED);
    public static final EmrFsStore.MetadataFile PLACED_DIRECTORY = MetadataFiles.directoryWithState(EmrFsStore.MetadataFile.State.PUT);
    public static final EmrFsStore.MetadataFile DELETED_DIRECTORY = MetadataFiles.directoryWithState(EmrFsStore.MetadataFile.State.DELETED);

    public static EmrFsStore.MetadataFile fileWithState(@NonNull EmrFsStore.MetadataFile.State state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return MetadataFiles.fileBuilder().setState(state).build();
    }

    public static EmrFsStore.MetadataFile directoryWithState(@NonNull EmrFsStore.MetadataFile.State state) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        return MetadataFiles.directoryBuilder().setState(state).build();
    }

    public static EmrFsStore.MetadataFile.Builder directoryBuilder() {
        return MetadataFiles.builder().setIsDirectory(true);
    }

    public static EmrFsStore.MetadataFile.Builder fileBuilder() {
        return MetadataFiles.builder().setIsDirectory(false);
    }

    private static EmrFsStore.MetadataFile.Builder builder() {
        return EmrFsStore.MetadataFile.newBuilder().setVersion(1);
    }

    private MetadataFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

