/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.EmrFsStore;
import com.amazon.ws.emr.hadoop.fs.consistency.FileStatusBuilder;
import com.amazon.ws.emr.hadoop.fs.consistency.exception.ConsistencyException;
import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.ConsistencyExceptionThrowableObjectMetadataRetriever;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.protobuf.InvalidProtocolBufferException;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import lombok.NonNull;
import org.apache.hadoop.fs.FileStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStatusExt
extends FileStatus {
    private static final Logger logger = LoggerFactory.getLogger(FileStatusExt.class);
    private Entity entity;
    private EmrFsStore.MetadataFile metadataFile;
    private String etag;
    private boolean folderMarkerExists;

    protected FileStatusExt(FileStatusBuilder builder) {
        super(builder.sizeBytes, builder.isDirectory, builder.blockReplication, builder.blockSize, builder.modificationTime, builder.accessTime, builder.fsPermission, builder.owner, builder.group, builder.qualifiedPath);
        this.entity = builder.entity;
        this.metadataFile = builder.metadataFile == null ? FileStatusExt.createMetadataFile(this.entity) : builder.metadataFile;
        this.etag = builder.entity == null ? null : this.entity.getEtag();
        this.folderMarkerExists = builder.folderMarkerExists;
    }

    private FileStatusExt(FileStatus fileStatus) throws IOException {
        super(fileStatus);
        if (fileStatus instanceof FileStatusExt) {
            this.setMetadataFieldsFrom((FileStatusExt)fileStatus);
        }
    }

    public static FileStatusExt copyOf(@NonNull FileStatus fileStatus) {
        if (fileStatus == null) {
            throw new NullPointerException("fileStatus is marked non-null but is null");
        }
        try {
            return new FileStatusExt(fileStatus);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static EmrFsStore.MetadataFile createMetadataFile(Entity entity) {
        if (entity == null) {
            return null;
        }
        try {
            return EmrFsStore.MetadataFile.parseFrom(entity.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileStatusBuilder builder() {
        return new FileStatusBuilder();
    }

    public boolean getMetadataEntryExists() {
        return this.metadataFile != null;
    }

    private void setMetadataFieldsFrom(FileStatusExt fileStatus) {
        this.entity = fileStatus.getEntity();
        this.metadataFile = fileStatus.getMetadataFile();
        this.etag = fileStatus.getEtag();
    }

    protected FileStatusExt() {
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EmrFsStore.MetadataFile getMetadataFile() {
        return this.metadataFile;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean isFolderMarkerExists() {
        return this.folderMarkerExists;
    }

    protected static final class LazyFileStatusExt
    extends FileStatusExt {
        private long plaintextLength = -1L;
        private AmazonS3Lite s3;
        private ConsistencyExceptionThrowableObjectMetadataRetriever objectMetadataRetriever;

        protected LazyFileStatusExt(FileStatusBuilder builder) {
            super(builder);
            this.s3 = builder.s3;
            this.objectMetadataRetriever = builder.objectMetadataRetriever;
        }

        public long getLen() {
            if (this.plaintextLength == -1L) {
                String bucket = S3UriUtils.pathToBucket(this.getPath());
                String key = S3UriUtils.pathToKey(this.getPath());
                ObjectMetadata metadata = null;
                if (this.objectMetadataRetriever != null && this.existsInMetadata()) {
                    try {
                        metadata = this.objectMetadataRetriever.get(this.getPath());
                    }
                    catch (ConsistencyException ce) {
                        throw new RuntimeException(ce);
                    }
                }
                this.plaintextLength = CSEUtils.getPlaintextLength(this.s3, bucket, key, metadata, true);
            }
            return this.plaintextLength;
        }

        private boolean existsInMetadata() {
            if (!this.getMetadataEntryExists()) {
                logger.info("Metadata Entry doesn't exist");
                return false;
            }
            EmrFsStore.MetadataFile metadataFile = this.getMetadataFile();
            return metadataFile.hasState() && metadataFile.getState() != EmrFsStore.MetadataFile.State.DELETED;
        }
    }
}

