/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.consistency.exception.ConsistencyException;
import com.amazon.ws.emr.hadoop.fs.property.RetryPolicyType;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Maps;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;

public final class ConsistentExceptionRetryPolicy {
    @VisibleForTesting
    public static RetryPolicy createConsistentExceptionRetryPolicy(Configuration configuration) {
        RetryPolicyType retryPolicyType = ConfigurationUtils.getRetryPolicyType(configuration);
        int retryPeriodSeconds = ConfigurationUtils.getConsistencyRetryPeriodSeconds(configuration);
        int retryCount = ConfigurationUtils.getConsistencyRetryCount(configuration);
        RetryPolicy consistencyPolicy = null;
        switch (retryPolicyType) {
            case EXPONENTIAL: 
            case FAST_FIRST_RETRY_EXPONENTIAL: {
                consistencyPolicy = RetryPolicies.exponentialBackoffRetry((int)retryCount, (long)retryPeriodSeconds, (TimeUnit)TimeUnit.SECONDS);
                break;
            }
            case FIXED: 
            case FAST_FIRST_RETRY_FIXED: {
                consistencyPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)retryCount, (long)retryPeriodSeconds, (TimeUnit)TimeUnit.SECONDS);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new RuntimeException("unknown retry policy type: " + (Object)((Object)retryPolicyType));
            }
        }
        HashMap<Class<ConsistencyException>, RetryPolicy> policyMap = Maps.newHashMap();
        policyMap.put(ConsistencyException.class, consistencyPolicy);
        return RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, policyMap);
    }

    private ConsistentExceptionRetryPolicy() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

