/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.consistency;

import com.amazon.ws.emr.hadoop.fs.EmrFSFutureCallback;
import com.amazon.ws.emr.hadoop.fs.EmrFsStore;
import com.amazon.ws.emr.hadoop.fs.consistency.FileDirectoryMismatchException;
import com.amazon.ws.emr.hadoop.fs.consistency.FileStatusExt;
import com.amazon.ws.emr.hadoop.fs.consistency.ItemKeys;
import com.amazon.ws.emr.hadoop.fs.consistency.concurrent.ConcurrentWrites;
import com.amazon.ws.emr.hadoop.fs.consistency.exception.ConsistencyException;
import com.amazon.ws.emr.hadoop.fs.consistency.exception.FileDeletedInMetadataNotFoundException;
import com.amazon.ws.emr.hadoop.fs.cse.CSEMultipartUploadOutputStream;
import com.amazon.ws.emr.hadoop.fs.cse.CSEUtils;
import com.amazon.ws.emr.hadoop.fs.dynamodb.Entity;
import com.amazon.ws.emr.hadoop.fs.dynamodb.EntityStore;
import com.amazon.ws.emr.hadoop.fs.dynamodb.ItemKey;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreException;
import com.amazon.ws.emr.hadoop.fs.dynamodb.impl.exception.EntityStoreExceptionCode;
import com.amazon.ws.emr.hadoop.fs.files.TemporaryDirectoriesGenerator;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.s3.ContentLengthSupplier;
import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystem;
import com.amazon.ws.emr.hadoop.fs.s3.FileCreationSubsystemFactory;
import com.amazon.ws.emr.hadoop.fs.s3.GetObjectInputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.MultipartCopyManager;
import com.amazon.ws.emr.hadoop.fs.s3.S3FSInputStream;
import com.amazon.ws.emr.hadoop.fs.s3.S3FSOutputStream;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectListing;
import com.amazon.ws.emr.hadoop.fs.s3.S3ObjectRequestFactory;
import com.amazon.ws.emr.hadoop.fs.s3.S3SelectInputStreamWithInfoFactory;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3EncryptionLite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.s3.lite.ConsistencyExceptionThrowableObjectMetadataRetriever;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.CopyMetadataObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.DefaultConcurrencyTokenResolver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.MetadataAdder;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.PreviousInstructionFileDeleter;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UnencryptedLengthHeaderAdder;
import com.amazon.ws.emr.hadoop.fs.s3.upload.dispatch.UploadObserver;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.ConsistentViewUploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlan;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlanner;
import com.amazon.ws.emr.hadoop.fs.s3.upload.plan.UploadPlannerFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.BasicFileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.s3n.FileStatusFactory;
import com.amazon.ws.emr.hadoop.fs.s3n2.S3FileSystem;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Iterables;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Lists;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Sets;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.protobuf.InvalidProtocolBufferException;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.tuple.MutablePair;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.tuple.Pair;
import com.amazon.ws.emr.hadoop.fs.shaded.org.joda.time.DateTime;
import com.amazon.ws.emr.hadoop.fs.staging.StagingMechanism;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazon.ws.emr.hadoop.fs.util.HadoopPaths;
import com.amazon.ws.emr.hadoop.fs.util.S3UriUtils;
import com.amazon.ws.emr.hadoop.fs.util.io.IOConsumer;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckerS3FileSystem
implements S3FileSystem {
    private static final Logger logger = LoggerFactory.getLogger(ConsistencyCheckerS3FileSystem.class);
    private static final int S3_LIST_MIN_KEYS = 1;
    private final S3ObjectRequestFactory s3ObjectRequestFactory;
    private final FileSystemOwner fileSystemOwner;
    private final FileCreationSubsystem fileCreationSubsystem;
    private final ConsistencyExceptionThrowableObjectMetadataRetriever objectMetadataRetriever;
    private final ContentLengthSupplier contentLengthSupplier;
    private final Consumer<org.apache.hadoop.fs.Path> pathChecker;
    private final IOConsumer<org.apache.hadoop.fs.Path> pathDeleter;
    private AmazonS3Lite s3;
    private EntityStore<Entity> entityStore;
    private Configuration configuration;
    private boolean isCheckConsistencyEnabled;
    private boolean cseEnabled;
    private boolean isPlaintextLenForCseEnabled;
    private boolean isEtagVerificationEnabled;
    private boolean isLazyInitializeS3ConnectionEnabled;
    private URI defaultUri;
    private String bucketName;
    private org.apache.hadoop.fs.Path workingDir;
    private String serverSideEncryptionAlgorithm;
    private String serverSideEncryptionKmsKeyId;
    private ListeningExecutorService listeningExecutorService;
    private TemporaryDirectoriesGenerator temporaryDirectoriesGenerator;
    private long defaultBlockSize;

    public ConsistencyCheckerS3FileSystem(AmazonS3Lite s3, EntityStore<Entity> entityStore, ListeningExecutorService listeningExecutorService, Configuration configuration, URI defaultUri, org.apache.hadoop.fs.Path workingDir, Consumer<org.apache.hadoop.fs.Path> pathChecker, IOConsumer<org.apache.hadoop.fs.Path> pathDeleter, long defaultBlockSize, FileSystemOwner user, ConsistencyExceptionThrowableObjectMetadataRetriever metadataRetriever) {
        this.configuration = configuration;
        this.isCheckConsistencyEnabled = ConfigurationUtils.isConsistencyEnabled(configuration);
        this.cseEnabled = ConfigurationUtils.isClientSideEncryptionEnabled(configuration);
        this.isEtagVerificationEnabled = ConfigurationUtils.isEtagVerificationEnabled(configuration);
        this.isLazyInitializeS3ConnectionEnabled = ConfigurationUtils.isLazyInitializeConnection(configuration);
        this.isPlaintextLenForCseEnabled = this.cseEnabled && ConfigurationUtils.isCSEPlaintextLenEnable(configuration);
        this.defaultUri = defaultUri;
        this.workingDir = workingDir;
        this.s3 = s3;
        this.entityStore = entityStore;
        this.listeningExecutorService = listeningExecutorService;
        this.bucketName = S3UriUtils.uriToBucket(defaultUri);
        if (ConfigurationUtils.isServerSideEncryptionEnabled(configuration)) {
            this.serverSideEncryptionAlgorithm = ConfigurationUtils.getServerSideEncryptionAlgorithm(configuration);
            this.serverSideEncryptionKmsKeyId = ConfigurationUtils.getServerSideEncryptionKmsKeyId(configuration);
        }
        this.s3ObjectRequestFactory = new S3ObjectRequestFactory(configuration, this.serverSideEncryptionKmsKeyId);
        this.defaultBlockSize = defaultBlockSize;
        List<Path> tempPaths = ConfigurationUtils.getTestedTempPaths(configuration);
        this.temporaryDirectoriesGenerator = new TemporaryDirectoriesGenerator(tempPaths);
        this.fileSystemOwner = user;
        this.pathChecker = pathChecker;
        this.pathDeleter = pathDeleter;
        this.fileCreationSubsystem = this.newFileCreationSubsystem();
        this.objectMetadataRetriever = metadataRetriever;
        this.contentLengthSupplier = ContentLengthSupplier.directSupplier(s3, configuration);
    }

    private FileCreationSubsystem newFileCreationSubsystem() {
        FileCreationSubsystemFactory factory = FileCreationSubsystemFactory.builder().uri(this.defaultUri).conf(this.configuration).s3(this.s3).requestFactory(this.s3ObjectRequestFactory).uploadObserver(this.newUploadObserver()).nonStagingPlannerFactory(this.newNonStagingPlannerFactory()).pathQualifier(this::makeQualified).pathChecker(this.pathChecker).pathDeleter(this.pathDeleter).fileStatusFactory(this.newFileStatusFactory()).exec(this.listeningExecutorService).build();
        return factory.create();
    }

    private UploadObserver newUploadObserver() {
        ArrayList<UploadObserver> observers = Lists.newArrayList(new PreviousInstructionFileDeleter(this.s3, this.configuration), this.newMetadataAdder());
        if (this.cseEnabled) {
            observers.add(new UnencryptedLengthHeaderAdder(this.s3, this.configuration));
        }
        return UploadObserver.chain(observers);
    }

    private MetadataAdder newMetadataAdder() {
        return new MetadataAdder(this.entityStore, new DefaultConcurrencyTokenResolver(this.entityStore), (bucket, key) -> this.mkdirs(S3UriUtils.keyToPath(key), false), ConcurrentWrites.defaultHandler(this.entityStore, this.s3));
    }

    private UploadPlannerFactory newNonStagingPlannerFactory() {
        return new ConsistentViewUploadPlannerFactory(this::getFileStatus);
    }

    private FileStatusFactory newFileStatusFactory() {
        return BasicFileStatusFactory.builder().fileSystemOwner(this.fileSystemOwner).pathQualifier(this::makeQualified).blockSizeSupplier(() -> this.defaultBlockSize).build();
    }

    @Override
    public FSDataOutputStream create(org.apache.hadoop.fs.Path path, boolean overwrite, Progressable progress, FileSystem.Statistics statistics) throws IOException {
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String absPath = absolutePath.toString();
        if (absPath.endsWith("_$folder$")) {
            throw new IOException(String.format("Unable to create file at path: %s", absPath));
        }
        UploadPlan uploadPlan = this.getUploadPlanner().plan(absolutePath, overwrite);
        if (!this.cseEnabled) {
            return new FSDataOutputStream((OutputStream)new S3FSOutputStream(this.s3, uploadPlan, this.serverSideEncryptionAlgorithm, this.serverSideEncryptionKmsKeyId, this.listeningExecutorService, progress, this.configuration, this.temporaryDirectoriesGenerator.createTemporaryDirectories()), statistics);
        }
        return new FSDataOutputStream((OutputStream)new CSEMultipartUploadOutputStream((AmazonS3EncryptionLite)this.s3, uploadPlan, this.configuration, progress, this.listeningExecutorService, this.temporaryDirectoriesGenerator.createTemporaryDirectory()), statistics);
    }

    @Override
    public boolean delete(org.apache.hadoop.fs.Path path, boolean recursive, boolean throwOnException) throws IOException {
        FileStatusExt fileStatus;
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        try {
            fileStatus = this.getFileStatus(absolutePath, false);
        }
        catch (FileNotFoundException e) {
            logger.debug("Unable to find path: '{}'", (Object)absolutePath);
            return false;
        }
        org.apache.hadoop.fs.Path parent = absolutePath.getParent();
        if (parent == null) {
            logger.debug("Unable to delete root '{}'", (Object)absolutePath);
            return false;
        }
        this.mkdir(parent, true);
        if (fileStatus.isDirectory()) {
            FileStatusExt[] childFiles;
            try {
                childFiles = this.listStatusRecursive(fileStatus, false, true, throwOnException);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            if (childFiles.length > 0 && !recursive) {
                throw new IOException(String.format("Unable to delete a non-empty directory with recursive turned off: %s", absolutePath));
            }
            this.concurrentDelete(Lists.reverse(Arrays.asList(childFiles)));
        }
        this.deleteFileOrDir(fileStatus);
        return true;
    }

    private void concurrentDelete(List<FileStatusExt> fileStatuses) throws IOException {
        EmrFSFutureCallback<FileStatusExt> emrFSFutureCallback = new EmrFSFutureCallback<FileStatusExt>(false);
        for (FileStatusExt fileStatus : fileStatuses) {
            logger.debug("Deleting {}", (Object)fileStatus.getPath());
            ListenableFuture<FileStatusExt> future = this.listeningExecutorService.submit(() -> {
                this.deleteFileOrDir(fileStatus);
                return fileStatus;
            });
            emrFSFutureCallback.registerFuture(future);
        }
        try {
            emrFSFutureCallback.ensureFuturesComplete();
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private void deleteFileOrDir(FileStatusExt fileStatus) {
        block9: {
            if (fileStatus.getEntity() != null) {
                EmrFsStore.MetadataFile existing;
                Entity entity = fileStatus.getEntity();
                try {
                    existing = EmrFsStore.MetadataFile.parseFrom(entity.getPayload());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                logger.debug("Changing state to DELETED for object '{}' in metadata.", (Object)fileStatus.getPath());
                EmrFsStore.MetadataFile metadataFile = EmrFsStore.MetadataFile.newBuilder().setIsDirectory(existing.getIsDirectory()).setState(EmrFsStore.MetadataFile.State.DELETED).setVersion(1).build();
                try {
                    entity.setDeletionTTL(this.getTTLForDeletedMetadata());
                    this.entityStore.update(entity.withPayload(metadataFile.toByteArray()));
                }
                catch (EntityStoreException e) {
                    if (e.getEntityStoreExceptionCode() == EntityStoreExceptionCode.STALE_ENTITY) {
                        logger.debug("File or Directory '{}' has been updated concurrently. Skipping.", (Object)fileStatus.getPath());
                        return;
                    }
                    throw e;
                }
            }
            String key = S3UriUtils.pathToKey(fileStatus.getPath());
            if (fileStatus.isDirectory()) {
                key = key + "_$folder$";
            }
            try {
                logger.debug("Deleting object {}/{} from s3", (Object)this.bucketName, (Object)key);
                this.s3.deleteObject(this.bucketName, key);
                CSEUtils.deletePreviousInstructionFileIfNecessary(this.configuration, this.s3, this.bucketName, key);
            }
            catch (AmazonServiceException e) {
                logger.warn(String.format("Unable to delete object %s/%s", this.bucketName, key), (Throwable)e);
                if (e.getStatusCode() == 404) break block9;
                throw e;
            }
        }
    }

    @Override
    public FSDataInputStream open(org.apache.hadoop.fs.Path path, int bufferSize, boolean throwOnInconsistency, FileSystem.Statistics statistics) throws IOException {
        FileStatusExt fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            throw new IOException("Unable to open a directory: " + path);
        }
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String key = S3UriUtils.pathToKey(absolutePath);
        GetObjectInputStreamWithInfoFactory getObjectInputStreamWithInfoFactory = this.isEtagVerificationEnabled ? GetObjectInputStreamWithInfoFactory.builder().s3(this.s3).etagVerification(fileStatus.getEtag()).build() : GetObjectInputStreamWithInfoFactory.builder().s3(this.s3).build();
        S3FSInputStream in = new S3FSInputStream(this.bucketName, key, this.contentLengthSupplier, getObjectInputStreamWithInfoFactory, this.configuration, statistics, this.entityStore, throwOnInconsistency, this.isLazyInitializeS3ConnectionEnabled, fileStatus.getLen());
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)in, bufferSize));
    }

    @Override
    public FileStatusExt getFileStatus(org.apache.hadoop.fs.Path path) throws IOException {
        return this.getFileStatus(path, true);
    }

    private FileStatusExt getFileStatus(org.apache.hadoop.fs.Path path, boolean throwOnDirectoryMismatch) throws IOException {
        return this.getStagingMechanism().isStagingDirectoryPath(path) ? this.getFileStatusFromStagingMechanism(path) : this.getFileStatusFromS3CheckingConsistencyIfEnabled(path, throwOnDirectoryMismatch);
    }

    private FileStatusExt getFileStatusFromStagingMechanism(org.apache.hadoop.fs.Path path) throws IOException {
        return FileStatusExt.copyOf(this.getStagingMechanism().getFileStatus(path));
    }

    private FileStatusExt getFileStatusFromS3CheckingConsistencyIfEnabled(org.apache.hadoop.fs.Path path, boolean throwOnDirectoryMismatch) throws IOException {
        String message;
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        String prefix = S3UriUtils.pathToKey(absolutePath);
        org.apache.hadoop.fs.Path qualifiedPath = this.makeQualified(absolutePath);
        if (prefix.length() == 0) {
            return this.newFolder(prefix, true);
        }
        Entity entity = null;
        if (this.isCheckConsistencyEnabled) {
            ItemKey itemKey = ItemKeys.toItemKey(this.bucketName, prefix);
            entity = this.entityStore.retrieve(itemKey);
        }
        EmrFsStore.MetadataFile metadataFile = null;
        if (entity != null) {
            metadataFile = EmrFsStore.MetadataFile.parseFrom(entity.getPayload());
        } else {
            logger.debug("No metadata entry found for '{}'.", (Object)qualifiedPath);
        }
        if (metadataFile != null && metadataFile.getState() == EmrFsStore.MetadataFile.State.DELETED) {
            throw new FileDeletedInMetadataNotFoundException(String.format("File '%s' is marked as deleted in the metadata", prefix), entity, metadataFile);
        }
        logger.debug("Retrieving metadata for key '{}'", (Object)prefix);
        ObjectMetadata s3ObjectMetadata = this.getS3ObjectMetadata(this.bucketName, prefix);
        if (s3ObjectMetadata != null) {
            logger.debug("Metadata represents 'file' for key {}", (Object)prefix);
            FileStatusExt fileStatusExt = this.newFile(prefix, CSEUtils.getPlaintextLength(this.s3, this.bucketName, prefix, s3ObjectMetadata, this.configuration), s3ObjectMetadata.getLastModified().getTime(), entity, false);
            if (metadataFile != null && metadataFile.getIsDirectory()) {
                if (throwOnDirectoryMismatch) {
                    String message2 = String.format("Key '%s/%s' is marked as directory in metadata but is file in s3", this.bucketName, prefix);
                    throw new FileDirectoryMismatchException(message2);
                }
                return this.newFolder(prefix, entity, false);
            }
            return fileStatusExt;
        }
        if (metadataFile != null && !metadataFile.getIsDirectory()) {
            String message3 = String.format("Key '%s' is present in metadata but not s3", prefix);
            throw new ConsistencyException(message3, Collections.singletonList(absolutePath));
        }
        String folderKey = prefix + "_$folder$";
        logger.debug("No metadata returned for key '{}', attempting to fetch folder file '{}'", (Object)folderKey);
        s3ObjectMetadata = this.getS3ObjectMetadata(this.bucketName, folderKey);
        if (s3ObjectMetadata != null) {
            if (throwOnDirectoryMismatch && metadataFile != null && !metadataFile.getIsDirectory()) {
                String message4 = String.format("Key '%s/%s' is NOT marked as directory in metadata but is directory in s3", this.bucketName, prefix);
                throw new FileDirectoryMismatchException(message4);
            }
            return this.newFolder(prefix, entity, true);
        }
        int keysCount = 0;
        HashSet<String> commonPrefixes = Sets.newHashSetWithExpectedSize(1);
        try {
            ListObjectsV2Result objectListing;
            String continuationToken = null;
            do {
                ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(prefix + "/").withDelimiter("/").withMaxKeys(1).withContinuationToken(continuationToken);
                objectListing = this.s3.listObjectsV2(listObjectsRequest);
                continuationToken = objectListing.getNextContinuationToken();
                commonPrefixes.addAll(objectListing.getCommonPrefixes());
            } while (continuationToken != null && (keysCount += objectListing.getObjectSummaries().size()) == 0 && commonPrefixes.isEmpty());
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        if (!commonPrefixes.isEmpty() || keysCount > 0) {
            return this.newFolder(prefix, entity, false);
        }
        if (metadataFile != null) {
            message = String.format("Directory '%s' present in the metadata but not s3", prefix);
            throw new ConsistencyException(message, Collections.singletonList(absolutePath));
        }
        message = String.format("No such file or directory: '%s'", prefix);
        throw new FileNotFoundException(message);
    }

    @Override
    public FileStatusExt[] listStatus(org.apache.hadoop.fs.Path path, boolean throwOnConsistency) throws IOException {
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        FileStatusExt fileStatus = this.getFileStatus(absolutePath);
        if (!fileStatus.isDirectory()) {
            return new FileStatusExt[]{fileStatus};
        }
        return this.listStatus(fileStatus, true, false, throwOnConsistency);
    }

    /*
     * WARNING - void declaration
     */
    private FileStatusExt[] listStatus(FileStatusExt fileStatus, boolean throwOnDirectoryMismatch, boolean includeDeleted, boolean throwOnInconsistency) throws IOException {
        TreeSet<FileStatusExt> results;
        String prefix = S3UriUtils.pathToKey(fileStatus.getPath());
        boolean fastList = ConfigurationUtils.isFastList(this.configuration);
        int fastListBatchSize = ConfigurationUtils.getFastListBatchSize(this.configuration);
        Map<Object, Object> entities = this.isCheckConsistencyEnabled && !fastList ? this.getEntityListForFolder(this.bucketName, prefix) : new HashMap();
        if (fastList) {
            logger.debug("Fast listing {}", (Object)fileStatus.getPath());
            results = new ConcurrentSkipListSet();
            ArrayList<ListenableFuture<Void>> futures = Lists.newArrayList();
            ItemKey queryKey = ItemKeys.toItemKeyForListingPrefix(this.bucketName, prefix);
            entities = new ConcurrentHashMap();
            String startKey = null;
            boolean oneMoreBatch = true;
            Iterator<Entity> entityIterator = this.entityStore.list(queryKey).iterator();
            int i = 0;
            while (entityIterator.hasNext()) {
                void var13_19;
                Entity e = entityIterator.next();
                entities.put(e.getItemKey(), MutablePair.of(e, false));
                if (++i % fastListBatchSize != 0) continue;
                if (!entityIterator.hasNext()) {
                    Object var13_20 = null;
                    oneMoreBatch = false;
                } else {
                    String string = ItemKeys.getS3Key(e.getItemKey());
                }
                ListStatusWorker listStatusWorker = new ListStatusWorker(prefix, startKey, (String)var13_19, includeDeleted, throwOnDirectoryMismatch, entities, results);
                startKey = var13_19;
                ListenableFuture<Void> future = this.listeningExecutorService.submit(listStatusWorker);
                futures.add(future);
            }
            if (oneMoreBatch) {
                ListStatusWorker listStatusWorker = new ListStatusWorker(prefix, startKey, null, includeDeleted, throwOnDirectoryMismatch, entities, results);
                ListenableFuture<Void> future = this.listeningExecutorService.submit(listStatusWorker);
                futures.add(future);
            }
            for (ListenableFuture<Void> future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IOException(e);
                }
            }
        } else {
            logger.debug("Single-threaded listing {}", (Object)fileStatus.getPath());
            results = Sets.newTreeSet();
            ListStatusWorker listStatusWorker = new ListStatusWorker(prefix, includeDeleted, throwOnDirectoryMismatch, entities, results);
            try {
                listStatusWorker.call();
            }
            catch (AmazonClientException e) {
                throw new IOException(e);
            }
        }
        Iterator<Map.Entry<Object, Object>> entityIterator = entities.entrySet().iterator();
        while (entityIterator.hasNext()) {
            Map.Entry<Object, Object> entity = entityIterator.next();
            if (((Boolean)((MutablePair)entity.getValue()).getRight()).booleanValue()) {
                entityIterator.remove();
                continue;
            }
            if ("_$folder$".equals(((ItemKey)entity.getKey()).getRangeKey())) {
                entityIterator.remove();
                continue;
            }
            EmrFsStore.MetadataFile metadataFile = EmrFsStore.MetadataFile.parseFrom(((Entity)((MutablePair)entity.getValue()).getLeft()).getPayload());
            if (metadataFile.getState() != EmrFsStore.MetadataFile.State.DELETED) continue;
            entityIterator.remove();
        }
        if (!entities.isEmpty()) {
            ArrayList<org.apache.hadoop.fs.Path> inconsistentPaths = new ArrayList<org.apache.hadoop.fs.Path>();
            for (ItemKey itemKey : entities.keySet()) {
                inconsistentPaths.add(new org.apache.hadoop.fs.Path(ItemKeys.toPathString(itemKey)));
                String errorMessage = String.format("No s3 object for metadata item %s/%s", itemKey.getHashKey(), itemKey.getRangeKey());
                if (throwOnInconsistency) {
                    logger.error(errorMessage);
                    continue;
                }
                logger.warn(errorMessage);
            }
            if (throwOnInconsistency) {
                Entity e = (Entity)((MutablePair)Iterables.getFirst(entities.values(), null)).getLeft();
                ItemKey itemKey = e.getItemKey();
                String errorMessage = String.format("%d items inconsistent (no s3 object for associated metadata item). First object: %s/%s", entities.size(), itemKey.getHashKey(), itemKey.getRangeKey());
                throw new ConsistencyException(errorMessage, inconsistentPaths);
            }
        }
        return results.toArray(new FileStatusExt[0]);
    }

    private Map<ItemKey, MutablePair<Entity, Boolean>> getEntityListForFolder(String bucketName, String prefix) {
        ItemKey queryKey = ItemKeys.toItemKeyForListingPrefix(bucketName, prefix);
        HashMap<ItemKey, MutablePair<Entity, Boolean>> entities = new HashMap<ItemKey, MutablePair<Entity, Boolean>>();
        for (Entity e : this.entityStore.list(queryKey)) {
            entities.put(e.getItemKey(), MutablePair.of(e, false));
        }
        return entities;
    }

    private void doListStatusRecursive(FileStatusExt fileStatus, boolean throwOnDirectoryMismatch, boolean includeDeleted, List<FileStatusExt> children, boolean throwOnException) throws IOException {
        FileStatusExt[] immediateChildren = this.listStatus(fileStatus, throwOnDirectoryMismatch, includeDeleted, throwOnException);
        children.addAll(Arrays.asList(immediateChildren));
        for (FileStatusExt child : immediateChildren) {
            if (!child.isDirectory()) continue;
            this.doListStatusRecursive(child, throwOnDirectoryMismatch, includeDeleted, children, throwOnException);
        }
    }

    private FileStatusExt[] listStatusRecursive(FileStatusExt fileStatus, boolean throwOnDirectoryMismatch, boolean includeDeleted, boolean throwOnException) throws IOException {
        ArrayList<FileStatusExt> children = Lists.newArrayList();
        this.doListStatusRecursive(fileStatus, throwOnDirectoryMismatch, includeDeleted, children, throwOnException);
        return children.toArray(new FileStatusExt[0]);
    }

    private void checkForFolderMismatch(FileStatusExt fileStatus, boolean throwOnMismatch) throws FileDirectoryMismatchException {
        if (fileStatus.getMetadataEntryExists() && fileStatus.isDirectory() != fileStatus.getMetadataFile().getIsDirectory()) {
            String message = String.format("%s is a common prefix in s3 but a file in emr metadata", fileStatus.getPath());
            if (throwOnMismatch) {
                throw new FileDirectoryMismatchException(message);
            }
            logger.warn(message);
        }
    }

    @Override
    public void mkdirs(org.apache.hadoop.fs.Path path) throws IOException {
        this.mkdirs(path, true);
    }

    private void mkdirs(org.apache.hadoop.fs.Path path, boolean createInS3) throws IOException {
        org.apache.hadoop.fs.Path absolutePath = this.makeAbsolute(path);
        org.apache.hadoop.fs.Path strippedPath = HadoopPaths.stripTrailingSeparator(absolutePath);
        Stack<org.apache.hadoop.fs.Path> paths = new Stack<org.apache.hadoop.fs.Path>();
        do {
            paths.push(strippedPath);
        } while ((strippedPath = strippedPath.getParent()) != null);
        while (!paths.empty()) {
            org.apache.hadoop.fs.Path p = (org.apache.hadoop.fs.Path)paths.pop();
            this.mkdir(p, createInS3);
        }
    }

    private void mkdir(org.apache.hadoop.fs.Path path, boolean createInS3) throws IOException {
        String prefix = S3UriUtils.pathToKey(path);
        try {
            FileStatusExt fileStatus = this.getFileStatus(path);
            if (fileStatus.isFile()) {
                String message = String.format("Cannot create directory for key '%s/%s' since it is a file.", this.bucketName, prefix);
                throw new IOException(message);
            }
            if (fileStatus.isDirectory() && fileStatus.getEntity() == null) {
                this.createFolder(prefix, createInS3 && !fileStatus.isFolderMarkerExists(), null);
            }
        }
        catch (FileDeletedInMetadataNotFoundException e) {
            this.createFolder(prefix, createInS3, e.getEntity());
        }
        catch (FileNotFoundException e) {
            this.createFolder(prefix, createInS3, null);
        }
    }

    private void createFolderInS3(String key) throws IOException {
        String dirPrefix = key + "_$folder$";
        logger.debug("Making dir '{}/{}' in S3", (Object)this.bucketName, (Object)key);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType("binary/octet-stream");
        objectMetadata.setContentLength(0L);
        if (!Strings.isNullOrEmpty(this.serverSideEncryptionAlgorithm)) {
            objectMetadata.setSSEAlgorithm(this.serverSideEncryptionAlgorithm);
        }
        CannedAccessControlList acl = ConfigurationUtils.getAcl(this.configuration);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);){
            PutObjectRequest putObjectRequest = this.s3ObjectRequestFactory.newPutObjectRequest(this.bucketName, dirPrefix, inputStream, objectMetadata);
            if (acl != null) {
                putObjectRequest.setCannedAcl(acl);
            }
            this.s3.putObject(putObjectRequest);
            CSEUtils.deletePreviousInstructionFileIfNecessary(this.configuration, this.s3, this.bucketName, dirPrefix);
        }
    }

    private void createFolder(String prefix, boolean createInS3, Entity entity) throws IOException {
        if (Strings.isNullOrEmpty(prefix)) {
            return;
        }
        if (createInS3) {
            this.createFolderInS3(prefix);
        } else {
            logger.debug("Creating dir '{}/{}' only in Metadata", (Object)this.bucketName, (Object)prefix);
        }
        EmrFsStore.MetadataFile metadataFile = EmrFsStore.MetadataFile.newBuilder().setIsDirectory(true).setState(EmrFsStore.MetadataFile.State.PUT).setVersion(1).build();
        ItemKey itemKey = null;
        try {
            if (entity == null) {
                itemKey = ItemKeys.toItemKey(this.bucketName, prefix);
                this.entityStore.create(new Entity(itemKey, metadataFile.toByteArray()));
            } else {
                itemKey = entity.getItemKey();
                entity.setDeletionTTL(0L);
                this.entityStore.update(entity.withPayload(metadataFile.toByteArray()));
            }
        }
        catch (EntityStoreException e) {
            if (ConcurrentWrites.isCausedByConcurrentWrite(e)) {
                Entity currentEntity = this.entityStore.retrieve(itemKey);
                EmrFsStore.MetadataFile currentMetadata = EmrFsStore.MetadataFile.parseFrom(currentEntity.getPayload());
                if (currentMetadata.getState() != EmrFsStore.MetadataFile.State.DELETED && currentMetadata.getIsDirectory()) {
                    logger.debug("Directory '{}/{}' has been created concurrently.", (Object)this.bucketName, (Object)prefix);
                    return;
                }
                String dirPrefix = prefix + "_$folder$";
                try {
                    this.s3.deleteObject(this.bucketName, dirPrefix);
                    CSEUtils.deletePreviousInstructionFileIfNecessary(this.configuration, this.s3, this.bucketName, dirPrefix);
                }
                catch (AmazonClientException ace) {
                    logger.debug("Unable to delete orphan S3 object '{}/{}'.", (Object)this.bucketName, (Object)dirPrefix);
                }
            }
            throw new IOException(String.format("Unable to create directory '%s/%s' due to concurrent write", this.bucketName, prefix), e);
        }
    }

    private FileStatusExt newFolder(String folderName, boolean folderMarkerExists) {
        return this.newFolder(folderName, null, folderMarkerExists);
    }

    private FileStatusExt newFolder(String folderName, Entity entity, boolean folderMarkerExists) {
        org.apache.hadoop.fs.Path qualifiedPath = this.makeQualified(S3UriUtils.keyToPath(folderName));
        return FileStatusExt.builder().entity(entity).isDirectory(true).qualifiedPath(qualifiedPath).owner(this.fileSystemOwner.getFullUserName()).group(this.fileSystemOwner.getGroup()).folderMarkerExists(folderMarkerExists).build();
    }

    private FileStatusExt newFile(S3ObjectSummary s3ObjectSummary, Entity entity, boolean lazyLoad) {
        return this.newFile(s3ObjectSummary.getKey(), s3ObjectSummary.getSize(), s3ObjectSummary.getLastModified().getTime(), entity, lazyLoad);
    }

    private FileStatusExt newFile(String fileName, long sizeBytes, long lastModified, Entity entity, boolean lazyLoad) {
        org.apache.hadoop.fs.Path qualifiedPath = this.makeQualified(S3UriUtils.keyToPath(fileName));
        return FileStatusExt.builder().entity(entity).sizeBytes(sizeBytes).blockSize(this.defaultBlockSize).modificationTime(lastModified).qualifiedPath(qualifiedPath).owner(this.fileSystemOwner.getFullUserName()).group(this.fileSystemOwner.getGroup()).lazyLoad(lazyLoad).isPlaintextLenForCseEnabled(this.isPlaintextLenForCseEnabled).s3(this.s3).objectMetadataRetriever(this.objectMetadataRetriever).build();
    }

    private ObjectMetadata getS3ObjectMetadata(String bucket, String key) {
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(bucket, key);
        try {
            return this.s3.getObjectMetadata(getObjectMetadataRequest);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 403) {
                return null;
            }
            throw e;
        }
    }

    private org.apache.hadoop.fs.Path makeAbsolute(org.apache.hadoop.fs.Path path) {
        return S3UriUtils.makeAbsolute(this.workingDir, path);
    }

    @Override
    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst, boolean throwOnException) throws IOException {
        FileStatusExt sourceFileStatus;
        org.apache.hadoop.fs.Path absDstPath;
        org.apache.hadoop.fs.Path absSrcPath;
        block9: {
            absSrcPath = this.makeAbsolute(src);
            if (absSrcPath.equals((Object)(absDstPath = this.makeAbsolute(dst)))) {
                logger.info(String.format("Unable to rename: source '%s' is the same as destination", absSrcPath));
                return false;
            }
            sourceFileStatus = this.getFileStatus(absSrcPath);
            if (sourceFileStatus.isDirectory() && absDstPath.toString().startsWith(absSrcPath.toString() + "/")) {
                throw new IOException(String.format("Unable to rename: source '%s' is a directory and destination '%s' is inside source", absSrcPath, absDstPath));
            }
            try {
                if (this.getFileStatus(absDstPath).isDirectory()) {
                    logger.debug("Using dst '{}' as output directory", (Object)absDstPath);
                    absDstPath = new org.apache.hadoop.fs.Path(absDstPath, src.getName());
                    try {
                        this.getFileStatus(absDstPath);
                        logger.info(String.format("Unable to rename: destination '%s' already exists.", absDstPath));
                        return false;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        break block9;
                    }
                }
                logger.info(String.format("Unable to rename: destination '%s' already exists as a file", absDstPath));
                return false;
            }
            catch (FileNotFoundException e) {
                this.mkdirs(absDstPath.getParent(), false);
            }
        }
        if (sourceFileStatus.isFile()) {
            String srcKey = S3UriUtils.pathToKey(absSrcPath);
            String dstKey = S3UriUtils.pathToKey(absDstPath);
            logger.debug("Copying source object {} to {}", (Object)src, (Object)dst);
            this.doSingleCopy(srcKey, dstKey);
        } else {
            List<FileStatusExt> sourceFileStatuses = Arrays.asList(this.listStatusRecursive(sourceFileStatus, true, false, throwOnException));
            logger.debug("Recursively copying objects under {} to {}", (Object)src, (Object)dst);
            this.doMultiThreadedCopy(sourceFileStatuses, absSrcPath, absDstPath, throwOnException);
        }
        logger.debug("Deleting source object(s) {}", (Object)src);
        this.delete(absSrcPath, sourceFileStatus.isDirectory(), throwOnException);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSingleCopy(String srcKey, String dstKey) throws IOException {
        try {
            this.createMultipartCopyManager(srcKey, dstKey).copy();
        }
        catch (Exception e) {
            logger.info("Exception {} thrown in doSingleCopy from '{}' to '{}'", new Object[]{e.getClass().getCanonicalName(), srcKey, dstKey});
            if (e instanceof IOException) {
                try {
                    this.delete(S3UriUtils.keyToPath(dstKey), true, false);
                    logger.info("Marked legacy file metadata as DELETED in DDB and deleted file potentially uploaded to S3");
                }
                catch (Exception exp) {
                    logger.info("Ignoring delete failure caused by {}", (Object)exp.getMessage());
                }
                finally {
                    throw e;
                }
            }
            throw e;
        }
    }

    private void doMultiThreadedCopy(List<FileStatusExt> sourceFileStatuses, org.apache.hadoop.fs.Path absSrcPath, org.apache.hadoop.fs.Path absDstPath, boolean throwOnException) throws IOException {
        String dstFileKey;
        String srcFileKey;
        String srcDirKey = S3UriUtils.pathToKey(absSrcPath);
        String dstDirKey = S3UriUtils.pathToKey(absDstPath);
        EmrFSFutureCallback<String> emrFsFutureCallback = new EmrFSFutureCallback<String>(true);
        ArrayList<FileStatusExt> regularSourceFiles = new ArrayList<FileStatusExt>(sourceFileStatuses.size());
        this.mkdir(absDstPath, true);
        for (FileStatusExt sourceFileStatus : sourceFileStatuses) {
            if (sourceFileStatus.isDirectory()) {
                srcFileKey = S3UriUtils.pathToKey(sourceFileStatus.getPath());
                dstFileKey = EmrFsUtils.makeDestFileKey(srcDirKey, dstDirKey, srcFileKey);
                org.apache.hadoop.fs.Path dstPath = S3UriUtils.keyToPath(dstFileKey);
                this.mkdir(dstPath, true);
                continue;
            }
            regularSourceFiles.add(sourceFileStatus);
        }
        try {
            for (FileStatusExt sourceFileStatus : regularSourceFiles) {
                if (emrFsFutureCallback.isCancelled()) break;
                srcFileKey = S3UriUtils.pathToKey(sourceFileStatus.getPath());
                dstFileKey = EmrFsUtils.makeDestFileKey(srcDirKey, dstDirKey, srcFileKey);
                logger.debug("Rename source key {} to destination key {} under destination directory {}", new Object[]{srcFileKey, dstFileKey, dstDirKey});
                for (Callable<String> callable : this.createCopyCallables(srcFileKey, dstFileKey)) {
                    emrFsFutureCallback.registerFuture(this.listeningExecutorService.submit(callable));
                }
            }
            emrFsFutureCallback.ensureFuturesComplete();
        }
        catch (FileNotFoundException | RuntimeException e) {
            this.delete(absDstPath, true, throwOnException);
            throw new IOException("Failed to copy from " + srcDirKey + " to " + dstDirKey, e);
        }
    }

    @VisibleForTesting
    protected MultipartCopyManager createMultipartCopyManager(String srcKey, String dstKey) {
        return new MultipartCopyManager.Builder().withS3(this.s3).withExecutorService(this.listeningExecutorService).withSrcBucketName(this.bucketName).withSrcKey(srcKey).withDstBucketName(this.bucketName).withDstKey(dstKey).withAcl(ConfigurationUtils.getAcl(this.configuration)).withServerSideEncryption(this.serverSideEncryptionAlgorithm).withServerSideKmsKeyId(this.serverSideEncryptionKmsKeyId).withConf(this.configuration).withObjectMetadataRetriever(this.objectMetadataRetriever).withUploadObserver(new CopyMetadataObserver(this.entityStore)).build();
    }

    @VisibleForTesting
    List<Callable<String>> createCopyCallables(String srcKey, String dstKey) throws IOException {
        try {
            return this.createMultipartCopyManager(srcKey, dstKey).createCopyCallables();
        }
        catch (AmazonServiceException e) {
            throw this.handleAmazonServiceException(srcKey, e);
        }
    }

    private IOException handleAmazonServiceException(String key, AmazonServiceException e) throws IOException {
        if (e.getStatusCode() == 404) {
            return new FileNotFoundException("Expected key '" + key + "' does not exist in S3");
        }
        throw new IOException(e);
    }

    private long getTTLForDeletedMetadata() {
        if (ConfigurationUtils.isDeleteTTLEnabled(this.configuration)) {
            return DateTime.now().getMillis() / 1000L + ConfigurationUtils.getDeleteTTLExpirationLength(this.configuration);
        }
        return 0L;
    }

    @Override
    public FSDataInputStream select(org.apache.hadoop.fs.Path path, Configuration selectOptions, int bufferSize, boolean throwOnInconsistency, FileSystem.Statistics statistics) throws IOException {
        FileStatusExt fileStatus = this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            throw new IOException("Unable to open a directory: " + path);
        }
        String key = S3UriUtils.pathToKey(this.makeAbsolute(path));
        logger.info("Opening S3 Select '" + path + "' for reading");
        S3FSInputStream in = new S3FSInputStream(this.bucketName, key, this.contentLengthSupplier, new S3SelectInputStreamWithInfoFactory(this.s3, selectOptions), this.configuration, statistics, this.entityStore, throwOnInconsistency, false, fileStatus.getLen());
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)in, bufferSize));
    }

    @Override
    public void close() throws IOException {
        this.fileCreationSubsystem.close();
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return this.getStagingMechanism();
    }

    private StagingMechanism getStagingMechanism() {
        return this.fileCreationSubsystem.getStagingMechanism();
    }

    private UploadPlanner getUploadPlanner() {
        return this.fileCreationSubsystem.getUploadPlanner();
    }

    private org.apache.hadoop.fs.Path makeQualified(org.apache.hadoop.fs.Path path) {
        return path.makeQualified(this.defaultUri, this.workingDir);
    }

    class ListStatusWorker
    implements Callable<Void> {
        String startKey;
        String endKey;
        boolean includeDeleted;
        boolean throwOnDirectoryMismatch;
        Map<ItemKey, MutablePair<Entity, Boolean>> entities;
        S3ObjectListing s3ObjectListing;
        SortedSet<FileStatusExt> results;

        ListStatusWorker(String prefix, boolean includeDeleted, boolean throwOnDirectoryMismatch, Map<ItemKey, MutablePair<Entity, Boolean>> entities, SortedSet<FileStatusExt> results) {
            this(prefix, null, null, includeDeleted, throwOnDirectoryMismatch, entities, results);
        }

        ListStatusWorker(String prefix, String startKey, String endKey, boolean includeDeleted, boolean throwOnDirectoryMismatch, Map<ItemKey, MutablePair<Entity, Boolean>> entities, SortedSet<FileStatusExt> results) {
            if (!Strings.isNullOrEmpty(prefix)) {
                prefix = prefix.equals("/") ? "" : prefix + "/";
            }
            this.startKey = prefix + startKey;
            this.endKey = prefix + endKey;
            this.includeDeleted = includeDeleted;
            this.throwOnDirectoryMismatch = throwOnDirectoryMismatch;
            this.entities = entities;
            this.results = results;
            ListObjectsV2Request listObjectsRequest = new ListObjectsV2Request().withBucketName(ConsistencyCheckerS3FileSystem.this.bucketName).withPrefix(prefix).withDelimiter("/").withStartAfter(startKey);
            this.s3ObjectListing = new S3ObjectListing(ConsistencyCheckerS3FileSystem.this.s3, listObjectsRequest, endKey);
        }

        @Override
        public Void call() throws FileDirectoryMismatchException {
            for (Pair<S3ObjectSummary, String> p : this.s3ObjectListing) {
                FileStatusExt newFileStatus;
                if (p.getLeft() == null || p.getLeft().getKey().endsWith("_$folder$")) {
                    boolean folderMarkerExists;
                    String s3Prefix;
                    if (p.getLeft() == null) {
                        s3Prefix = p.getRight();
                        if (s3Prefix.endsWith("/")) {
                            s3Prefix = s3Prefix.substring(0, s3Prefix.length() - 1);
                        }
                        folderMarkerExists = false;
                    } else {
                        s3Prefix = p.getLeft().getKey().substring(0, p.getLeft().getKey().length() - "_$folder$".length());
                        folderMarkerExists = true;
                    }
                    if (s3Prefix.equals("")) continue;
                    MutablePair<Entity, Boolean> entity = this.entities.get(ItemKeys.toItemKey(ConsistencyCheckerS3FileSystem.this.bucketName, s3Prefix));
                    if (entity != null) {
                        if (!((Boolean)entity.getValue()).booleanValue()) {
                            entity.setValue(true);
                        } else {
                            this.entities.remove(((Entity)entity.getKey()).getItemKey());
                        }
                        newFileStatus = ConsistencyCheckerS3FileSystem.this.newFolder(s3Prefix, entity.getLeft(), folderMarkerExists);
                    } else {
                        newFileStatus = ConsistencyCheckerS3FileSystem.this.newFolder(s3Prefix, null, folderMarkerExists);
                    }
                } else {
                    if (p.getLeft().getKey().endsWith("/")) {
                        logger.info("Skipping s3 object ending with slash: '{}'", (Object)p.getLeft().getKey());
                        continue;
                    }
                    if (CSEUtils.isInstructionFile(p.getLeft().getKey())) {
                        logger.info("Skipping instruction file: '{}'", (Object)p.getLeft().getKey());
                        continue;
                    }
                    MutablePair<Entity, Boolean> entity = this.entities.remove(ItemKeys.toItemKey(ConsistencyCheckerS3FileSystem.this.bucketName, p.getLeft().getKey()));
                    newFileStatus = entity != null ? ConsistencyCheckerS3FileSystem.this.newFile(p.getLeft(), entity.getLeft(), true) : ConsistencyCheckerS3FileSystem.this.newFile(p.getLeft(), null, true);
                }
                if (!this.includeDeleted && newFileStatus.getMetadataEntryExists() && newFileStatus.getMetadataFile().getState() == EmrFsStore.MetadataFile.State.DELETED) continue;
                ConsistencyCheckerS3FileSystem.this.checkForFolderMismatch(newFileStatus, this.throwOnDirectoryMismatch);
                this.results.add(newFileStatus);
            }
            return null;
        }
    }
}

