/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.concurrent;

import com.amazon.ws.emr.hadoop.fs.concurrent.Producer;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Optional;
import java.util.concurrent.BlockingQueue;

public class BlockingQueueProducer<T>
implements Runnable {
    private BlockingQueue<Optional<T>> queue;
    private Producer<T> producer;

    @Override
    public void run() {
        while (this.producer.canProduce()) {
            T value = this.producer.produce();
            try {
                this.queue.put(Optional.of(value));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BlockingQueueProducer(BlockingQueue<Optional<T>> queue, Producer<T> producer) {
        this.queue = queue;
        this.producer = producer;
    }
}

