/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.annotation;

import com.amazon.ws.emr.hadoop.fs.annotation.AnnotationProcessErrorCode;
import com.amazon.ws.emr.hadoop.fs.annotation.AnnotationProcessException;
import com.amazon.ws.emr.hadoop.fs.annotation.AnnotationProcessor;
import com.amazon.ws.emr.hadoop.fs.annotation.Annotations;
import com.amazon.ws.emr.hadoop.fs.annotation.SystemVariableLookup;
import com.amazon.ws.emr.hadoop.fs.client.YarnClient;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.Maps;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.text.StrSubstitutor;
import com.amazon.ws.emr.hadoop.fs.util.JobUtils;
import com.amazonaws.services.elasticmapreduce.spi.EMRFSAnnotationProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationProcessorImpl
implements AnnotationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationProcessorImpl.class);
    static final Pattern SYSTEM_VARIABLE_PATTERN = Pattern.compile("^\\$\\{.+\\}$");
    private final StrSubstitutor systemVariableResolver;
    private final Configuration configuration;

    public AnnotationProcessorImpl(Configuration configuration) {
        this.configuration = configuration;
        try (YarnClient yarnClient = new YarnClient(configuration);){
            String applicationId = JobUtils.getApplicationId();
            this.configuration.set("yarn.application.type", yarnClient.getApplicationTypeById(applicationId));
        }
        catch (IOException e) {
            logger.warn("Yarn Http client could not be closed.", (Throwable)e);
        }
        this.systemVariableResolver = new StrSubstitutor(new SystemVariableLookup(configuration));
    }

    @VisibleForTesting
    AnnotationProcessorImpl(Configuration configuration, ApplicationType applicationType) {
        this.configuration = configuration;
        this.configuration.set("yarn.application.type", applicationType.name());
        this.systemVariableResolver = new StrSubstitutor(new SystemVariableLookup(configuration));
    }

    @Override
    public Annotations process(String annotationConfigurationFile) {
        try {
            Map<String, String> annotationEntries = this.loadAnnotationEntries(annotationConfigurationFile);
            this.validateCharsetAndSize(annotationEntries);
            Map<String, String> resolvedAnnotationEntries = this.resolveSystemVariables(annotationEntries);
            return Annotations.of(resolvedAnnotationEntries);
        }
        catch (AnnotationProcessException ex) {
            logger.warn("Annotation processing failed.", (Throwable)ex);
            return Annotations.of(ex.getErrorCode());
        }
        catch (Exception ex) {
            logger.error("Annotation processing failed due to internal error.", (Throwable)ex);
            return Annotations.of(AnnotationProcessErrorCode.EMRFSAnnotationProcessError);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    Map<String, String> loadAnnotationEntries(String annotationConfigurationFile) throws AnnotationProcessException {
        if (this.getClass().getClassLoader().getResource(annotationConfigurationFile) == null) {
            return Collections.emptyMap();
        }
        try (InputStream annotationEntriesInputStream = this.getClass().getClassLoader().getResourceAsStream(annotationConfigurationFile);){
            Properties annotationProperties = new Properties();
            annotationProperties.load(annotationEntriesInputStream);
            HashMap<String, String> annotationEntries = Maps.newHashMap(Maps.fromProperties(annotationProperties));
            String annotationProviderClassName = annotationProperties.getProperty("fs.s3.annotation.provider");
            if (annotationProviderClassName != null) {
                annotationEntries.remove("fs.s3.annotation.provider");
                Map<String, String> annotationEntriesFromProvider = this.loadAnnotationEntriesFromCustomAnnotationProvider(annotationProviderClassName);
                annotationEntries.putAll(annotationEntriesFromProvider);
            }
            HashMap<String, String> hashMap = annotationEntries;
            return hashMap;
        }
        catch (IOException ex) {
            logger.error("Loading annotation configuration file failed.", (Throwable)ex);
            throw new AnnotationProcessException(AnnotationProcessErrorCode.EMRFSAnnotationProcessError, String.format("Load annotation configuration file %s failed.", annotationConfigurationFile), ex);
        }
    }

    private Map<String, String> loadAnnotationEntriesFromCustomAnnotationProvider(String annotationProviderClass) throws AnnotationProcessException {
        try {
            EMRFSAnnotationProvider annotationProvider = (EMRFSAnnotationProvider)ReflectionUtils.newInstance(Class.forName(annotationProviderClass), (Configuration)this.configuration);
            return annotationProvider.getAnnotations();
        }
        catch (ClassNotFoundException e) {
            logger.warn("class not found: {}", (Object)annotationProviderClass, (Object)e);
            throw new AnnotationProcessException(AnnotationProcessErrorCode.EMRFSAnnotationProviderNotFoundError);
        }
        catch (ClassCastException e) {
            logger.warn("class {} cannot be casted to EMRFSAnnotationProvider.", (Object)annotationProviderClass, (Object)e);
            throw new AnnotationProcessException(AnnotationProcessErrorCode.EMRFSAnnotationProviderCastError);
        }
        catch (Throwable t) {
            logger.warn("class {} execution failed.", (Object)annotationProviderClass, (Object)t);
            throw new AnnotationProcessException(AnnotationProcessErrorCode.EMRFSAnnotationProviderExecutionError);
        }
    }

    @VisibleForTesting
    Map<String, String> resolveSystemVariables(Map<String, String> annotationEntries) {
        HashMap<String, String> resolvedAnnotationEntries = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : annotationEntries.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (this.containsSystemVariable(value)) {
                try {
                    value = this.systemVariableResolver.replace(value);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Invalid system variable {}.", (Object)value, (Object)ex);
                }
            }
            resolvedAnnotationEntries.put(key, value);
        }
        return resolvedAnnotationEntries;
    }

    private boolean containsSystemVariable(String value) {
        return SYSTEM_VARIABLE_PATTERN.matcher(StringUtils.trimToEmpty(value)).matches();
    }

    @VisibleForTesting
    void validateCharsetAndSize(Map<String, String> annotationEntries) throws AnnotationProcessException {
        int byteSize = 0;
        for (Map.Entry<String, String> entry : annotationEntries.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (this.containsInvalidCharacters(key) || this.containsInvalidCharacters(value)) {
                throw new AnnotationProcessException(AnnotationProcessErrorCode.EMRFSAnnotationInvalidCharacterError);
            }
            byteSize += key.getBytes(SUPPORTED_CHARSET).length;
            byteSize += value.getBytes(SUPPORTED_CHARSET).length;
        }
        if (byteSize > 2048) {
            throw new AnnotationProcessException(AnnotationProcessErrorCode.EMRFSAnnotationSizeLimitExceededError);
        }
    }

    private boolean containsInvalidCharacters(String value) {
        if (StringUtils.isBlank(value)) {
            return false;
        }
        return !SUPPORTED_CHARSET.newEncoder().canEncode(value);
    }

    static enum ApplicationType {
        MAPREDUCE,
        SPARK,
        OTHER;

    }
}

