/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs;

import com.amazon.ws.emr.hadoop.fs.guice.EmrFSProdModule;
import com.amazon.ws.emr.hadoop.fs.s3n.S3NativeFileSystem;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Guice;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Inject;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Injector;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.Key;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.inject.name.Names;
import com.amazon.ws.emr.hadoop.fs.staging.StagingDirectoryServices;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.EmrFsUtils;
import com.amazon.ws.emr.hadoop.fs.util.S3AccessPointUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataInputStreamBuilder;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.list.OrderedListCapable;
import org.apache.hadoop.fs.list.OrderedListingBuilder;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.staging.StagingDirectoryCapable;
import org.apache.hadoop.fs.staging.StagingDirectoryService;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class EmrFileSystem
extends FileSystem
implements StagingDirectoryCapable,
OrderedListCapable {
    private static final Logger logger = LoggerFactory.getLogger(EmrFileSystem.class);
    private FileSystem fileSystem = null;
    private boolean initialized = false;
    private boolean useConsistency = false;
    @Inject
    private Injector injector;

    public EmrFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public synchronized void initialize(URI uri, Configuration configuration) throws IOException {
        if (this.initialized) {
            return;
        }
        uri = S3AccessPointUtils.convertS3apARNColonFormatIfApply(uri);
        Configuration conf = this.initializeConfiguration(uri, configuration);
        super.initialize(uri, conf);
        if (this.fileSystem == null) {
            if (this.injector == null) {
                this.injector = Guice.createInjector(new EmrFSProdModule(uri, conf, this.statistics));
            }
            this.useConsistency = ConfigurationUtils.isConsistencyEnabled(conf);
            FileSystem fs = this.useConsistency ? this.injector.getInstance(Key.get(FileSystem.class, (Annotation)Names.named("s3n2"))) : this.injector.getInstance(Key.get(FileSystem.class, (Annotation)Names.named("s3n")));
            logger.debug("Consistency {}, using {} as filesystem implementation", (Object)(this.useConsistency ? "enabled" : "disabled"), (Object)fs.getClass().getCanonicalName());
            fs.setConf(conf);
            fs.initialize(uri, conf);
            this.fileSystem = fs;
        }
        this.initialized = true;
    }

    @VisibleForTesting
    Configuration initializeConfiguration(URI uri, Configuration configuration) {
        if (!ConfigurationUtils.isLoadConfigurationEnabled(configuration)) {
            return configuration;
        }
        logger.debug("Loading {} into configuration", (Object)"emrfs-site.xml");
        Configuration.addDefaultResource((String)"emrfs-site.xml");
        Configuration newConf = new Configuration();
        newConf.setAllowNullValueProperties(true);
        newConf.addResource(configuration);
        String bucketName = uri.getAuthority();
        Map bucketConfigMap = newConf.getValByRegex("^fs\\.s3\\.bucket\\." + bucketName + "\\..+");
        if (!bucketConfigMap.isEmpty()) {
            for (Map.Entry entry : bucketConfigMap.entrySet()) {
                String newKey = ((String)entry.getKey()).replaceFirst("^fs\\.s3\\.bucket\\." + bucketName + "\\.", "fs.s3.");
                if (newConf.onlyKeyExists((String)entry.getKey())) {
                    logger.debug("Unset configuration {} for bucket {} due to {}.", new Object[]{newKey, bucketName, entry.getKey()});
                    newConf.unset(newKey);
                    continue;
                }
                logger.debug("Override configuration {} for bucket {} due to {}.", new Object[]{newKey, bucketName, entry.getKey()});
                newConf.set(newKey, (String)entry.getValue());
            }
        }
        return newConf;
    }

    public String toString() {
        return this.fileSystem.toString();
    }

    public Configuration getConf() {
        return this.fileSystem.getConf();
    }

    public void setConf(Configuration conf) {
        if (this.fileSystem != null) {
            this.fileSystem.setConf(conf);
        }
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.fileSystem.getFileBlockLocations(file, start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path path, long start, long len) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getFileBlockLocations(path, start, len);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fileSystem.getServerDefaults();
    }

    public FsServerDefaults getServerDefaults(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getServerDefaults(path);
    }

    public Path resolvePath(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.resolvePath(path);
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.open(path, bufferSize);
    }

    public FSDataInputStream open(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.open(path);
    }

    public FSDataOutputStream create(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path);
    }

    public FSDataOutputStream create(Path path, boolean overwrite) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, overwrite);
    }

    public FSDataOutputStream create(Path path, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, progress);
    }

    public FSDataOutputStream create(Path path, short replication) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, replication);
    }

    public FSDataOutputStream create(Path path, short replication, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, replication, progress);
    }

    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, overwrite, bufferSize);
    }

    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, overwrite, bufferSize, progress);
    }

    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, overwrite, bufferSize, replication, blockSize);
    }

    public FSDataOutputStream create(Path path, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.create(path, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    public FSDataOutputStream createNonRecursive(Path path, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.createNonRecursive(path, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.createNonRecursive(path, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream createNonRecursive(Path path, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.createNonRecursive(path, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean createNewFile(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.createNewFile(path);
    }

    public FSDataOutputStream append(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.append(path);
    }

    public FSDataOutputStream append(Path path, int bufferSize) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.append(path, bufferSize);
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.append(path, bufferSize, progress);
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        trg = S3AccessPointUtils.convertS3apARNColonFormatIfApply(trg);
        psrcs = S3AccessPointUtils.convertS3apARNColonFormatIfApply(psrcs);
        this.fileSystem.concat(trg, psrcs);
    }

    public short getReplication(Path src) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        return this.fileSystem.getReplication(src);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        return this.fileSystem.setReplication(src, replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        return this.fileSystem.rename(src, dst);
    }

    public boolean delete(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.delete(path);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.delete(path, recursive);
    }

    public boolean deleteOnExit(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.deleteOnExit(path);
    }

    public boolean cancelDeleteOnExit(Path path) {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.cancelDeleteOnExit(path);
    }

    public boolean exists(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.exists(path);
    }

    public boolean isDirectory(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.isDirectory(path);
    }

    public boolean isFile(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.isFile(path);
    }

    public long getLength(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getLength(path);
    }

    public ContentSummary getContentSummary(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getContentSummary(path);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.listCorruptFileBlocks(path);
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.listStatus(path);
    }

    public FileStatus[] listStatus(Path path, PathFilter filter) throws FileNotFoundException, IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.listStatus(path, filter);
    }

    public FileStatus[] listStatus(Path[] files) throws FileNotFoundException, IOException {
        files = S3AccessPointUtils.convertS3apARNColonFormatIfApply(files);
        return this.fileSystem.listStatus(files);
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws FileNotFoundException, IOException {
        files = S3AccessPointUtils.convertS3apARNColonFormatIfApply(files);
        return this.fileSystem.listStatus(files, filter);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        pathPattern = S3AccessPointUtils.convertS3apARNColonFormatIfApply(pathPattern);
        return this.fileSystem.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        pathPattern = S3AccessPointUtils.convertS3apARNColonFormatIfApply(pathPattern);
        return this.fileSystem.globStatus(pathPattern, filter);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path path) throws FileNotFoundException, IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.listLocatedStatus(path);
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path path, boolean recursive) throws FileNotFoundException, IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.listFiles(path, recursive);
    }

    public Path getHomeDirectory() {
        return this.fileSystem.getHomeDirectory();
    }

    public Path getWorkingDirectory() {
        return this.fileSystem.getWorkingDirectory();
    }

    public void setWorkingDirectory(Path newDir) {
        newDir = S3AccessPointUtils.convertS3apARNColonFormatIfApply(newDir);
        this.fileSystem.setWorkingDirectory(newDir);
    }

    public boolean mkdirs(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.mkdirs(path);
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.mkdirs(path, permission);
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        srcs = S3AccessPointUtils.convertS3apARNColonFormatIfApply(srcs);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.moveFromLocalFile(srcs, dst);
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.moveFromLocalFile(src, dst);
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyFromLocalFile(src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        srcs = S3AccessPointUtils.convertS3apARNColonFormatIfApply(srcs);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.moveToLocalFile(src, dst);
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyToLocalFile(src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyToLocalFile(delSrc, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst, boolean useRawLocalFileSystem) throws IOException {
        src = S3AccessPointUtils.convertS3apARNColonFormatIfApply(src);
        dst = S3AccessPointUtils.convertS3apARNColonFormatIfApply(dst);
        this.fileSystem.copyToLocalFile(delSrc, src, dst, useRawLocalFileSystem);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        fsOutputFile = S3AccessPointUtils.convertS3apARNColonFormatIfApply(fsOutputFile);
        tmpLocalFile = S3AccessPointUtils.convertS3apARNColonFormatIfApply(tmpLocalFile);
        return this.fileSystem.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        fsOutputFile = S3AccessPointUtils.convertS3apARNColonFormatIfApply(fsOutputFile);
        tmpLocalFile = S3AccessPointUtils.convertS3apARNColonFormatIfApply(tmpLocalFile);
        this.fileSystem.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void close() throws IOException {
        try {
            if (this.fileSystem != null) {
                this.fileSystem.close();
                this.fileSystem = null;
            }
        }
        finally {
            super.close();
        }
    }

    public long getUsed() throws IOException {
        return this.fileSystem.getUsed();
    }

    public long getBlockSize(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getBlockSize(path);
    }

    public long getDefaultBlockSize() {
        return this.fileSystem.getDefaultBlockSize();
    }

    public long getDefaultBlockSize(Path path) {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getDefaultBlockSize(path);
    }

    public short getDefaultReplication() {
        return this.fileSystem.getDefaultReplication();
    }

    public short getDefaultReplication(Path path) {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getDefaultReplication(path);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getFileStatus(path);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        target = S3AccessPointUtils.convertS3apARNColonFormatIfApply(target);
        link = S3AccessPointUtils.convertS3apARNColonFormatIfApply(link);
        this.fileSystem.createSymlink(target, link, createParent);
    }

    public FileStatus getFileLinkStatus(Path path) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getFileLinkStatus(path);
    }

    public boolean supportsSymlinks() {
        return this.fileSystem.supportsSymlinks();
    }

    public Path getLinkTarget(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getLinkTarget(path);
    }

    public FileChecksum getFileChecksum(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getFileChecksum(path);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fileSystem.setVerifyChecksum(verifyChecksum);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.fileSystem.setWriteChecksum(writeChecksum);
    }

    public FsStatus getStatus() throws IOException {
        return this.fileSystem.getStatus();
    }

    public FsStatus getStatus(Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.getStatus(path);
    }

    public void setPermission(Path path, FsPermission permission) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        this.fileSystem.setPermission(path, permission);
    }

    public void setOwner(Path path, String username, String groupname) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        this.fileSystem.setOwner(path, username, groupname);
    }

    public void setTimes(Path path, long mtime, long atime) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        this.fileSystem.setTimes(path, mtime, atime);
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        this.fileSystem.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        this.fileSystem.deleteSnapshot(path, snapshotName);
    }

    public String getScheme() {
        if (this.fileSystem.getUri() != null) {
            return this.fileSystem.getUri().getScheme();
        }
        return EmrFsUtils.getDefaultScheme();
    }

    public URI getUri() {
        return this.fileSystem.getUri();
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public String getName() {
        return this.fileSystem.getName();
    }

    public Path makeQualified(Path path) {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.makeQualified(path);
    }

    public FileSystem[] getChildFileSystems() {
        return this.fileSystem.getChildFileSystems();
    }

    public void enableCache() {
        S3NativeFileSystem.enableCache();
    }

    public void disableCache() {
        S3NativeFileSystem.disableCache();
    }

    public Path[] getEmptySubDirPaths(Path parent) throws IOException {
        parent = S3AccessPointUtils.convertS3apARNColonFormatIfApply(parent);
        if (this.useConsistency) {
            throw new UnsupportedOperationException("getEmptySubDirPaths not supported when consistency is enabled");
        }
        return ((S3NativeFileSystem)this.fileSystem).getEmptySubDirPaths(parent);
    }

    public FSDataInputStreamBuilder openFile(Path path) {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.fileSystem.openFile(path);
    }

    public StagingDirectoryService getStagingDirectoryService() {
        return StagingDirectoryServices.getService(this.fileSystem);
    }

    public boolean isOrderedListEnabled() {
        return this.fileSystem instanceof OrderedListCapable && ((OrderedListCapable)this.fileSystem).isOrderedListEnabled();
    }

    public Comparator<Path> listOrder() {
        return this.asOrderedListCapable().listOrder();
    }

    public OrderedListingBuilder listFilesInOrder(@Nonnull Path path) throws IOException {
        path = S3AccessPointUtils.convertS3apARNColonFormatIfApply(path);
        return this.asOrderedListCapable().listFilesInOrder(path);
    }

    private OrderedListCapable asOrderedListCapable() {
        if (this.fileSystem instanceof OrderedListCapable) {
            return (OrderedListCapable)this.fileSystem;
        }
        throw new UnsupportedOperationException("Ordered list is disabled");
    }

    public EmrFileSystem() {
    }
}

