/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.FutureCallback;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.Futures;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrFSFutureCallback<T>
implements FutureCallback<T> {
    private static final Logger logger = LoggerFactory.getLogger(EmrFSFutureCallback.class);
    private List<ListenableFuture<T>> listenableFutures;
    private boolean cancelFuturesOnFailure;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public EmrFSFutureCallback(boolean cancelFuturesOnFailure) {
        this.cancelFuturesOnFailure = cancelFuturesOnFailure;
        this.listenableFutures = Collections.synchronizedList(new ArrayList());
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void registerFuture(ListenableFuture<T> future) {
        if (this.isCancelled()) {
            future.cancel(true);
        }
        this.listenableFutures.add(future);
        Futures.addCallback(future, this);
    }

    public void ensureFuturesComplete() throws RuntimeException {
        this.getResults();
    }

    public List<T> getResults() throws RuntimeException {
        RuntimeException re = null;
        ArrayList results = new ArrayList(this.listenableFutures.size());
        for (ListenableFuture<T> listenableFuture : this.listenableFutures) {
            try {
                Object r = listenableFuture.get();
                results.add(r);
            }
            catch (InterruptedException | CancellationException | ExecutionException exception) {
                if (exception instanceof InterruptedException | exception.getCause() instanceof InterruptedException) {
                    throw new RuntimeException(exception);
                }
                if (re != null) continue;
                re = new RuntimeException(exception);
            }
        }
        if (re != null) {
            throw re;
        }
        return results;
    }

    @Override
    public void onSuccess(T obj) {
    }

    @Override
    public synchronized void onFailure(Throwable t) {
        if ((this.cancelFuturesOnFailure || t instanceof InterruptedException) && this.cancelled.compareAndSet(false, true)) {
            logger.debug("Cancel all futures");
            this.cancelFutures();
        }
    }

    private void cancelFutures() {
        for (ListenableFuture<T> listenableFuture : this.listenableFutures) {
            listenableFuture.cancel(true);
        }
    }
}

