/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs;

import com.amazon.ws.emr.hadoop.fs.property.RetryPolicyType;
import com.amazon.ws.emr.hadoop.fs.property.SeekStrategyName;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.SSEAlgorithm;

public final class Constants {
    public static final int EMR_FS_FILE_PROTO_VERSION = 1;
    public static final String FOLDER_SUFFIX = "_$folder$";
    public static final int S3_LIST_MAX_KEYS = 1000;
    public static final int S3_LIST_MIN_KEYS = 1;
    public static final String CONFIGURATION_FILE_NAME = "emrfs-site.xml";
    public static final String ANNOTATIONS_CONF_FILE_NAME = "emrfs-annotations.properties";
    public static final String ENTITYSTORE_TAG_HASHKEY = "MultiKeyStoreTag";
    public static final String ENTITYSTORE_TAG_TABLEROLE_KEY = "TableRole";
    public static final String DEFAULT_EMRFS_METADATA_TABLE_NAME = "EmrFSMetadata";
    public static final boolean DEFAULT_EMRFS_METADATA_ETAG_VERIFICATION = true;
    public static final int DEFAULT_READ_CAPACITY = 500;
    public static final int DEFAULT_WRITE_CAPACITY = 100;
    public static final long DEFAULT_PART_SIZE = 0x8000000L;
    public static final long MIN_PART_SIZE = 0x500000L;
    public static final long MAX_PART_SIZE = 0x140000000L;
    public static final double DEFAULT_PARTS_COMPLETED_THRESHOLD_PERCENT = 0.5;
    public static final double DEFAULT_MULTIPART_FRACTION_PART_AVG_COMPLETION_TIME = 1.0;
    public static final int MIN_PART_ATTEMPTS = 2;
    public static final int DEFAULT_PART_ATTEMPTS = 5;
    public static final boolean DEFAULT_CLEAN_INCOMPLETE_MULTIPART_ENABLED = false;
    public static final long DEFAULT_CLEAN_INCOMPLETE_MULTIPART_AGE_THRESHOLD_SECONDS = 604800L;
    public static final int DEFAULT_CLEAN_INCOMPLETE_MULTIPART_MAX_JITTER_DELAY_MILLIS = 10000;
    public static final long CLEANER_THREAD_INITIAL_DELAY_SECONDS = 0L;
    public static final long CLEANER_THREAD_FIXED_DELAY_SECONDS = 900L;
    public static final int DEFAULT_RENAME_ALGORITHM_VERSION = 1;
    public static final int DEFAULT_S3_THREADPOOL_SIZE = 20;
    public static final int MAX_S3_THREADPOOL_SIZE = 40;
    public static final int DEFAULT_S3_THREADPOOL_BUFFER_SIZE = 10000;
    public static final String YARN_RESOURCE_MANAGER_URL_CONF_NAME = "yarn.resourcemanager.webapp.address";
    public static final String YARN_APPLICATION_TYPE_CONF_NAME = "yarn.application.type";
    public static final String FS_S3_BUCKET_REGEX = "^fs\\.s3\\.bucket\\.";
    public static final String FS_S3_PREFIX = "fs.s3.";
    public static final String REQUESTER_PAYS_HEADER_KEY = "x-amz-request-payer";
    public static final String REQUESTER_PAYS_HEADER_VALUE = "requester";
    public static final int S3_API_MAX_BATCH_SIZE = 1000;
    public static final int FS_S3_MAX_RETRIES_DEFAULT = 10;
    public static final int DEFAULT_FS_S3_GET_OBJECT_INITIAL_SOCKET_TIMEOUT_MILLIS = 50000;
    public static final int MIN_FS_S3_TIMEOUT_SOCKET_MILLIS = 1;
    public static final boolean FS_S3_CONSISTENT_THROW_EXCEPTION_ON_INCONSISTENCY_DEFAULT = true;
    public static final double FS_S3_FAST_FIRST_RETRY_PERIOD_SECONDS_DEFAULT = 0.05;
    public static final int FS_S3_CONSISTENT_FAST_LIST_BATCH_SIZE_DEFAULT = 5000;
    public static final boolean FS_S3_AUTH_UGI_GET_GROUP_ENABLED_DEFAULT = true;
    public static final long FS_S3_METADATA_CACHE_EXPIRATION_SECONDS_DEFAULT = 60L;
    public static final boolean FS_S3_LAZY_INITIALIZE_CONNECTION_DEFAULT = true;
    public static final boolean FS_S3_LIST_FILES_INCREMENTAL_FETCH_ENABLED_DEFAULT = true;
    public static final boolean FS_S3_LIST_FILES_IN_ORDER_INCLUDE_DESCENDANTS_OF_FILES_DEFAULT = false;
    public static final boolean FS_S3_READ_FULLY_INTO_BUFFERS_OPTIMIZATION_ENABLED_DEFAULT = true;
    public static final boolean FS_S3_AUTH_AUDIT_ENABLED_DEFAULT = true;
    public static final boolean FS_S3_POSITIONED_READ_OPTIMIZATION_ENABLED_DEFAULT = true;
    public static final String FS_S3_SEEK_STRATEGY_DEFAULT = SeekStrategyName.LAZY.getName();
    public static final String FS_S3_CONSISTENT_RETRY_POLICY_TYPE_DEFAULT = RetryPolicyType.FAST_FIRST_RETRY_EXPONENTIAL.getName();
    public static final String SERVER_SIDE_ALGORITHM_FOR_KMS = SSEAlgorithm.KMS.getAlgorithm();
    public static final boolean FS_S3_REQUEST_STATISTICS_ENABLED_DEFAULT = false;
    public static final boolean FS_S3_AUTH_SECRETAGENT_ENABLED_DEFAULT = false;

    private Constants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

