/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.DefaultRequest;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.Request;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.SdkClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.http.HttpMethodName;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Marshaller;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.util.StringUtils;
import com.amazonaws.services.sqs.model.TagQueueRequest;
import java.util.Map;

public class TagQueueRequestMarshaller
implements Marshaller<Request<TagQueueRequest>, TagQueueRequest> {
    @Override
    public Request<TagQueueRequest> marshall(TagQueueRequest tagQueueRequest) {
        if (tagQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TagQueueRequest> request = new DefaultRequest<TagQueueRequest>(tagQueueRequest, "AmazonSQS");
        request.addParameter("Action", "TagQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagQueueRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(tagQueueRequest.getQueueUrl()));
        }
        Map<String, String> tags = tagQueueRequest.getTags();
        int tagsListIndex = 1;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Tags." + tagsListIndex + ".Key", StringUtils.fromString(entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Tags." + tagsListIndex + ".Value", StringUtils.fromString(entry.getValue()));
            }
            ++tagsListIndex;
        }
        return request;
    }
}

