/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Unmarshaller;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import javax.xml.stream.events.XMLEvent;

public class MessageAttributeValueStaxUnmarshaller
implements Unmarshaller<MessageAttributeValue, StaxUnmarshallerContext> {
    private static MessageAttributeValueStaxUnmarshaller instance;

    @Override
    public MessageAttributeValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return messageAttributeValue;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StringValue", targetDepth)) {
                    messageAttributeValue.setStringValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryValue", targetDepth)) {
                    messageAttributeValue.setBinaryValue(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StringListValue", targetDepth)) {
                    messageAttributeValue.withStringListValues(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryListValue", targetDepth)) {
                    messageAttributeValue.withBinaryListValues(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DataType", targetDepth)) continue;
                messageAttributeValue.setDataType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return messageAttributeValue;
    }

    public static MessageAttributeValueStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageAttributeValueStaxUnmarshaller();
        }
        return instance;
    }
}

