/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.MapEntry;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.transform.Unmarshaller;
import com.amazonaws.services.sqs.model.ListQueueTagsResult;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class ListQueueTagsResultStaxUnmarshaller
implements Unmarshaller<ListQueueTagsResult, StaxUnmarshallerContext> {
    private static ListQueueTagsResultStaxUnmarshaller instance;

    @Override
    public ListQueueTagsResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListQueueTagsResult listQueueTagsResult = new ListQueueTagsResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return listQueueTagsResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Tag", targetDepth)) continue;
                Map.Entry<String, String> entry = TagsMapEntryUnmarshaller.getInstance().unmarshall(context);
                listQueueTagsResult.addTagsEntry(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return listQueueTagsResult;
    }

    public static ListQueueTagsResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ListQueueTagsResultStaxUnmarshaller();
        }
        return instance;
    }

    private static class TagsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static TagsMapEntryUnmarshaller instance;

        private TagsMapEntryUnmarshaller() {
        }

        @Override
        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry<String, String> entry = new MapEntry<String, String>();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Key", targetDepth)) {
                        entry.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static TagsMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new TagsMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

