/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.property.RetryPolicyType;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.exception.ExceptionUtils;
import java.net.SocketException;
import java.util.Random;

public class RetryUtils {
    public static long calcRetryInterval(RetryPolicyType defaultRetryPolicy, long baseRetryInterval, int numOfAttempts, int fastFirstRetryDelay, Exception e) {
        double jitterMultiplier = new Random().nextDouble() + 0.5;
        long retryInterval = baseRetryInterval;
        switch (defaultRetryPolicy) {
            case EXPONENTIAL: {
                retryInterval = RetryUtils.getExpRetryWait(numOfAttempts, retryInterval);
                break;
            }
            case FAST_FIRST_RETRY_EXPONENTIAL: {
                if (numOfAttempts <= 0 && RetryUtils.shouldFastRetry(e)) {
                    retryInterval = Math.min((long)fastFirstRetryDelay, RetryUtils.getExpRetryWait(numOfAttempts, retryInterval));
                    break;
                }
                retryInterval = RetryUtils.getExpRetryWait(numOfAttempts, retryInterval);
                break;
            }
            case FAST_FIRST_RETRY_FIXED: {
                if (numOfAttempts <= 0 && RetryUtils.shouldFastRetry(e)) {
                    retryInterval = Math.min((long)fastFirstRetryDelay, retryInterval);
                    break;
                }
                retryInterval = Math.min(retryInterval, Long.MAX_VALUE);
                break;
            }
            default: {
                retryInterval = Math.min(retryInterval, Long.MAX_VALUE);
            }
        }
        return (long)((double)retryInterval * jitterMultiplier);
    }

    private static boolean shouldFastRetry(Exception e) {
        return e instanceof SocketException || ExceptionUtils.getRootCause(e) instanceof SocketException;
    }

    private static long getExpRetryWait(int numOfAttempts, long retryInterval) {
        return Math.min(retryInterval * (1L << numOfAttempts), Long.MAX_VALUE);
    }
}

