/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.hadoop.fs.Path;

public final class HadoopPaths {
    public static Path stripTrailingSeparator(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        HadoopPaths.checkNotOpaque(path);
        String pathString = path.toString();
        return HadoopPaths.hasTrailingSeparator(pathString) ? new Path(HadoopPaths.removeLastCharacter(pathString)) : path;
    }

    public static List<String> getComponentsOfAbsolutePath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        HadoopPaths.checkNotOpaque(path);
        Preconditions.checkArgument(HadoopPaths.isAbsoluteWhenNormalized(path), "Path (%s) must be absolute", path);
        String uriPath = path.toUri().getPath();
        return Arrays.stream(uriPath.split("/")).filter(component -> !component.isEmpty()).collect(Collectors.toList());
    }

    public static Path toFullyQualifiedPath(@NonNull String scheme, @NonNull String authority, @NonNull Iterable<String> components) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (components == null) {
            throw new NullPointerException("components");
        }
        String pathSegment = "/" + Joiner.on("/").join(components);
        return new Path(scheme, authority, pathSegment);
    }

    public static boolean isFullyQualified(Path path) {
        URI uri = path.toUri();
        return uri.getScheme() != null && uri.getAuthority() != null;
    }

    public static void checkNotOpaque(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        URI uri = path.toUri();
        Preconditions.checkArgument(!uri.isOpaque(), "Path as uri (%s) must not be opaque", uri);
    }

    private static boolean hasTrailingSeparator(String pathString) {
        return !pathString.equals("/") && pathString.endsWith("/");
    }

    private static String removeLastCharacter(String string) {
        return string.substring(0, string.length() - 1);
    }

    private static boolean isAbsoluteWhenNormalized(Path path) {
        URI uri = path.toUri();
        return uri.getAuthority() != null || path.isAbsolute();
    }

    private HadoopPaths() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

