/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;

public final class ExceptionCollector {
    private final List<Exception> exceptions = new ArrayList<Exception>();

    public void add(@NonNull Exception exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        this.exceptions.add(exception);
    }

    public <X extends Throwable> void throwIfNotEmpty(@NonNull Supplier<X> exceptionToThrow) throws X {
        if (exceptionToThrow == null) {
            throw new NullPointerException("exceptionToThrow");
        }
        if (this.exceptions.isEmpty()) {
            return;
        }
        Throwable toThrow = (Throwable)exceptionToThrow.get();
        toThrow.initCause(this.assembleSingleExceptionFromCollected());
        throw toThrow;
    }

    public <X extends Throwable> void rethrowIfNotEmpty(@NonNull Class<X> declaredType) throws X {
        if (declaredType == null) {
            throw new NullPointerException("declaredType");
        }
        if (this.exceptions.isEmpty()) {
            return;
        }
        Exception exception = this.assembleSingleExceptionFromCollected();
        Throwables.propagateIfPossible(exception, declaredType);
        throw new RuntimeException(exception);
    }

    private Exception assembleSingleExceptionFromCollected() {
        Exception cause = this.exceptions.get(0);
        for (Exception toSuppress : this.exceptions.subList(1, this.exceptions.size())) {
            cause.addSuppressed(toSuppress);
        }
        return cause;
    }
}

