/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.annotation.AnnotationProcessorImpl;
import com.amazon.ws.emr.hadoop.fs.identity.FileSystemOwner;
import com.amazon.ws.emr.hadoop.fs.s3.lite.AmazonS3Lite;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonClientException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.AmazonServiceException;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Region;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.RegionUtils;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.regions.Regions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Joiner;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Preconditions;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.base.Strings;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.collect.ImmutableMap;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.CommandLine;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.DefaultExecuteResultHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.DefaultExecutor;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.ExecuteWatchdog;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.exec.PumpStreamHandler;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.io.output.ByteArrayOutputStream;
import com.amazon.ws.emr.hadoop.fs.shaded.org.apache.commons.lang3.StringUtils;
import com.amazon.ws.emr.hadoop.fs.util.ConfigurationUtils;
import com.amazon.ws.emr.hadoop.fs.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrFsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EmrFsUtils.class);
    private static final String jobFlowId;
    private static final String DEFAULT_JOB_FLOW_ID = "UnknownJobFlowId";
    static final String S3_GOV_WEST_FIPS_ENDPOINT = "s3-fips-us-gov-west-1.amazonaws.com";
    private static final Map<Region, String> REGION_ENDPOINT_OVERRIDES;

    public static String getDefaultScheme() {
        return "s3n";
    }

    public static String pathToBucket(Path path) {
        return EmrFsUtils.uriToBucket(path.toUri());
    }

    public static String uriToBucket(URI uri) {
        return uri.getAuthority();
    }

    public static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        Preconditions.checkState(path.isAbsolute(), "Invalid path - must be absolute: " + path);
        String ret = path.toUri().getPath().substring(1);
        if (ret.endsWith("/") && ret.indexOf("/") != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static Path getPathForS3Object(String bucket, String key) {
        return new Path("s3://" + bucket + "/" + key);
    }

    public static Path keyToPath(String bucket, String key) {
        return new Path("/" + bucket + "/" + key);
    }

    public static Path keyToPath(String key) {
        return new Path("/" + key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String execCmd(String cmd) {
        DefaultExecutor executor = new DefaultExecutor();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(1000L);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        executor.setWatchdog(watchdog);
        CommandLine commandLine = new CommandLine(cmd);
        try (ByteArrayOutputStream stdOutStream = new ByteArrayOutputStream();){
            String stdOut;
            int exitValue;
            Throwable throwable;
            ByteArrayOutputStream stdErrStream;
            block27: {
                String string;
                block28: {
                    stdErrStream = new ByteArrayOutputStream();
                    throwable = null;
                    PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(stdOutStream, stdErrStream);
                    executor.setStreamHandler(pumpStreamHandler);
                    executor.execute(commandLine, resultHandler);
                    try {
                        resultHandler.waitFor();
                        exitValue = resultHandler.getExitValue();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    pumpStreamHandler.stop();
                    stdOut = stdOutStream.toString(StandardCharsets.UTF_8.name());
                    if (exitValue != 0) break block27;
                    string = stdOut;
                    if (stdErrStream == null) return string;
                    if (throwable == null) break block28;
                    try {
                        stdErrStream.close();
                        return string;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return string;
                    }
                }
                stdErrStream.close();
                return string;
            }
            try {
                try {
                    LOG.warn("Non-zero exit value of {} returned by '{}'", (Object)exitValue, (Object)cmd);
                    LOG.warn("stdout: {}", (Object)stdOut);
                    String stdErr = stdErrStream.toString(StandardCharsets.UTF_8.name());
                    LOG.warn("stderr: {}", (Object)stdErr);
                    throw new RuntimeException(String.format("Non-zero exit value of %d returned by '%s'", exitValue, cmd));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (stdErrStream == null) throw throwable4;
                if (throwable == null) {
                    stdErrStream.close();
                    throw throwable4;
                }
                try {
                    stdErrStream.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer safeCreateByteBuffer(byte[] buffer) {
        return ByteBuffer.wrap(buffer == null ? new byte[]{} : buffer);
    }

    private static String getEmrVersion() {
        String defaultValue = "1.0.0";
        String programPath = "/usr/share/aws/emr/util/version";
        File amiVersionProgram = new File(programPath);
        if (amiVersionProgram.exists()) {
            try {
                String result = EmrFsUtils.execCmd(programPath);
                if (!Strings.isNullOrEmpty(result)) {
                    return result;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to retrieve version information, error while executing 'version'", (Throwable)e);
            }
        }
        return defaultValue;
    }

    private static String addAnnotationsIfPresent(String userAgent, Configuration configuration) {
        try {
            if (EmrFsUtils.class.getClassLoader().getResource("emrfs-annotations.properties") == null) {
                return userAgent;
            }
            String annotations = new AnnotationProcessorImpl(configuration).process("emrfs-annotations.properties").toString();
            LOG.debug("EMRFS annotations: {}.", (Object)annotations);
            if (StringUtils.isBlank(annotations)) {
                return userAgent;
            }
            return userAgent + " " + annotations;
        }
        catch (Throwable t) {
            LOG.error("Adding EmrFs annotations failed.", t);
            return userAgent;
        }
    }

    private static String addFileSystemOwnerInformation(String userAgent, FileSystemOwner fileSystemOwner, Configuration configuration) {
        String fileSystemOwnerInformationFormat = " user:%s,groups:[%s]";
        if (!ConfigurationUtils.isAuthorizationAuditingEnabled(configuration) || fileSystemOwner == null) {
            return userAgent;
        }
        String username = fileSystemOwner.getFullUserName();
        String groups = Joiner.on(',').join(fileSystemOwner.getGroupNames());
        return userAgent + String.format(fileSystemOwnerInformationFormat, username, groups);
    }

    public static String getUserAgent(Configuration configuration) {
        return EmrFsUtils.getUserAgent(null, configuration);
    }

    public static String getUserAgent(FileSystemOwner fileSystemOwner, Configuration configuration) {
        boolean isConsistencyEnabled = ConfigurationUtils.isConsistencyEnabled(configuration);
        String subFsName = isConsistencyEnabled ? "s3c" : "s3n";
        String emrVersion = EmrFsUtils.getEmrVersion().replaceAll("\\s+", "");
        String userAgent = String.format("ElasticMapReduce/%s emrfs/%s", emrVersion, subFsName);
        userAgent = EmrFsUtils.addAnnotationsIfPresent(userAgent, configuration);
        userAgent = EmrFsUtils.addFileSystemOwnerInformation(userAgent, fileSystemOwner, configuration);
        return userAgent;
    }

    public static String makeDestFileKey(String srcDir, String dstDir, String srcFileKey) {
        String suffix = srcFileKey.substring(srcDir.length());
        String dstFileKey = dstDir.charAt(dstDir.length() - 1) != '/' && suffix.charAt(0) != '/' ? dstDir + "/" + suffix : dstDir + suffix;
        return dstFileKey;
    }

    public static AmazonS3Lite getAmazonS3LiteWithRetryPolicy(AmazonS3Lite s3) {
        return EmrFsUtils.getAmazonS3LiteWithRetryPolicy(s3, 5);
    }

    public static AmazonS3Lite getAmazonS3LiteWithRetryPolicy(AmazonS3Lite s3, int maxRetries) {
        RetryPolicy basePolicy = RetryPolicies.exponentialBackoffRetry((int)maxRetries, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<AmazonS3Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<AmazonS3Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(AmazonServiceException.class, basePolicy);
        exceptionToPolicyMap.put(AmazonClientException.class, basePolicy);
        exceptionToPolicyMap.put(AmazonS3Exception.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("completeMultipartUpload", methodPolicy);
        methodNameToPolicyMap.put("abortMultipartUpload", methodPolicy);
        methodNameToPolicyMap.put("uploadPart", methodPolicy);
        return (AmazonS3Lite)RetryProxy.create(AmazonS3Lite.class, (Object)s3, methodNameToPolicyMap);
    }

    public static String getRegion(Configuration configuration, String regionConf) {
        if (regionConf != null && configuration != null && configuration.get(regionConf) != null) {
            return configuration.get(regionConf);
        }
        if (Regions.getCurrentRegion() != null) {
            return Regions.getCurrentRegion().getName();
        }
        LOG.warn("Cannot get region info from Ec2 metadata, using us-east-1 for desktop.");
        return Regions.US_EAST_1.getName();
    }

    private static Region getRegion() {
        Region region = Regions.getCurrentRegion();
        if (region == null) {
            LOG.info("Unable to get region id from EC2 metadata. Defaulting to us-east-1");
            region = RegionUtils.getRegion(Regions.US_EAST_1.getName());
        }
        return region;
    }

    public static String getEndpoint(String service, Configuration config) {
        String endpoint;
        switch (service) {
            case "s3": {
                endpoint = EmrFsUtils.getS3Endpoint(config);
                break;
            }
            case "dynamodb": {
                endpoint = EmrFsUtils.getDynamoDbEndpoint(config);
                break;
            }
            default: {
                endpoint = EmrFsUtils.getEndpoint(service, EmrFsUtils.getRegion());
            }
        }
        LOG.debug("Using endpoint {} for service {}.", (Object)endpoint, (Object)service);
        return endpoint;
    }

    static String getEndpoint(String service, Region region) {
        return region.getServiceEndpoint(service);
    }

    public static String getDynamoDbEndpoint(Configuration config) {
        String configuredEndpoint = config.get("fs.s3.consistent.dynamodb.endpoint");
        if (configuredEndpoint != null) {
            return configuredEndpoint;
        }
        return EmrFsUtils.getEndpoint("dynamodb", EmrFsUtils.getRegion());
    }

    public static String getS3Endpoint(Configuration config) {
        String configuredEndpoint = config.get("fs.s3n.endpoint");
        if (configuredEndpoint != null) {
            return configuredEndpoint;
        }
        return EmrFsUtils.getS3Endpoint(EmrFsUtils.getRegion());
    }

    public static String getS3Endpoint(Region region) {
        String endpoint = REGION_ENDPOINT_OVERRIDES.get(region);
        if (endpoint != null) {
            return endpoint;
        }
        return EmrFsUtils.getEndpoint("s3", region);
    }

    public static String getS3Endpoint(Regions region) {
        return EmrFsUtils.getS3Endpoint(Region.getRegion(region));
    }

    public static String getJobFlowId() {
        if (Strings.isNullOrEmpty(jobFlowId)) {
            String id = PlatformInfo.forDefaultResourceLocations().getJobFlowId();
            return Strings.isNullOrEmpty(id) ? DEFAULT_JOB_FLOW_ID : id;
        }
        return jobFlowId;
    }

    public static void sleep(long backOffInterval) {
        try {
            Thread.sleep(backOffInterval);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Retry's backoff was interrupted by other process", ie);
        }
    }

    public static Path makeAbsolute(Path workingDirectory, Path path) {
        return path.isAbsolute() ? path : new Path(workingDirectory, path);
    }

    static {
        REGION_ENDPOINT_OVERRIDES = ImmutableMap.of(Region.getRegion(Regions.GovCloud), S3_GOV_WEST_FIPS_ENDPOINT);
        jobFlowId = EmrFsUtils.getJobFlowId();
    }
}

