/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ws.emr.hadoop.fs.util;

import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazon.ws.emr.hadoop.fs.shaded.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.annotations.VisibleForTesting;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.Cache;
import com.amazon.ws.emr.hadoop.fs.shaded.com.google.common.cache.CacheBuilder;
import com.amazon.ws.emr.hadoop.fs.util.AwsClientConfiguration;
import com.amazon.ws.emr.hadoop.fs.util.ClientConfigurationFactory;
import com.amazon.ws.emr.hadoop.fs.util.UserData;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public final class AWSSessionCredentialsProviderFactory {
    private static final String EMRFS_SESSION = "EmrFS-Session";
    private static final AWSSecurityTokenService STS_CLIENT = AWSSessionCredentialsProviderFactory.buildSTSClient();
    private static final Cache<String, AWSSessionCredentialsProvider> PROVIDERS_CACHE = CacheBuilder.newBuilder().maximumSize(100L).initialCapacity(10).concurrencyLevel(10).build();

    private AWSSessionCredentialsProviderFactory() {
    }

    @Nullable
    public static AWSSessionCredentialsProvider getCredentialsProviderForRoleArn(String roleArn) {
        if (roleArn == null) {
            return null;
        }
        AWSSessionCredentialsProvider cachedProvider = null;
        try {
            cachedProvider = PROVIDERS_CACHE.get(roleArn, () -> AWSSessionCredentialsProviderFactory.createCredentialsProviderForRoleArn(roleArn));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return cachedProvider;
    }

    private static AWSSessionCredentialsProvider createCredentialsProviderForRoleArn(String roleArn) {
        return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, EMRFS_SESSION).withStsClient(STS_CLIENT).build();
    }

    @VisibleForTesting
    static AWSSecurityTokenService buildSTSClient() {
        Optional<AwsClientConfiguration> awsClientConfiguration = UserData.ofDefaultResourceLocations().getInstanceAwsClientConfiguration();
        if (awsClientConfiguration.isPresent()) {
            ClientConfigurationFactory clientConfigurationFactory = new ClientConfigurationFactory(awsClientConfiguration.get());
            return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withClientConfiguration(clientConfigurationFactory.getClientConfiguration("sts"))).build();
        }
        return AWSSecurityTokenServiceClientBuilder.defaultClient();
    }
}

